<?php
declare(strict_types = 1);
$slodycze = [
    'Toffi'    => ['cena' => 3.00, 'stan' => 12],
    'Miętówki' => ['cena' => 2.00, 'stan' => 26],
    'Krówki'   => ['cena' => 4.00, 'stan' => 8],
];
$podatek = 20;

function komunikat_o_zamowieniu(int $stan): string 
{
    return ($stan < 10) ? 'Tak' : 'Nie';
}

function oblicz_laczna_wartosc(float $cena, int $liczba): float 
{
    return $cena * $liczba;
}

function oblicz_nalezny_podatek(float $cena, int $liczba, int $podatek = 0): float 
{
    return ($cena * $liczba) * ($podatek / 100);
}
?>

<!DOCTYPE html>
<html> 
  <head>
    <title>Przykład zastosowania funkcji</title>
    <link rel="stylesheet" href="css/styles.css">
  </head>
  <body>
    <h1>Sklep ze słodyczami</h1>
    <h2>Kontrola stanów magazynowych</h2>
    <table>
      <tr>
        <th>Produkt</th><th>Stan</th><th>Do zamówienia?</th><th>Wartość</th><th>Podatek</th>
      </tr>
      <?php foreach ($slodycze as $nazwa_produktu => $dane) { ?>
        <tr>
          <td><?=  $nazwa_produktu ?></td>
          <td><?=  $dane['stan'] ?></td>
          <td><?=  komunikat_o_zamowieniu($dane['stan']) ?></td>
          <td><?= oblicz_laczna_wartosc($dane['cena'], $dane['stan']) ?> zł</td>
          <td><?= oblicz_nalezny_podatek($dane['cena'], $dane['stan'], $podatek) ?> zł</td>
       </tr>
      <?php } ?>
    </table>
  </body>
</html>