<?php
declare(strict_types = 1);                                         // Włącz ścisłą kontrolę typów
include '../../src/bootstrap.php';                                 // Dołącz plik konfiguracyjny
czyAdmin($sesja->rola);                                            // Sprawdź status administratora

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);          // Sprawdź, czy id jest wartością całkowitą
if (!$id) {                                                        // Jeśli nie ma id
    przekieruj('admin/uczestnicy.php', ['niepowodzenie' => 'Nie znaleziono uczestnika']); // Przekieruj z błędem
}

$uczestnik = $cms->pobierzUczestnika()->pobierz($id);              // Pobierz dane uczestnika
if (!$uczestnik) {                                                 // Jeśli nie ma danych
    przekieruj('admin/uczestnicy.php', ['niepowodzenie' => 'Nie znaleziono uczestnika']); // Przekieruj z błędem
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                        // Jeśli formularz został przesłany
    $rola = $_POST['rola'] ?? '';                                  // Pobierz nową rolę
    if (in_array($rola, ['uczestnik', 'admin', 'zawieszony'])) {   // Jeśli rola jest prawidłowa
        $uczestnik['rola'] = $rola;                                // Zaktualizuj rolę w tablicy
        $cms->pobierzUczestnika()->aktualizuj($uczestnik);         // Zaktualizuj rolę w bazie
        przekieruj('admin/uczestnicy.php', ['sukces' => 'Rola została zmieniona']); // Przekieruj
    }
}

$dane['uczestnik']  = $uczestnik;                                  // Dane do szablonu

echo $twig->render('admin/edytuj-role.html', $dane);               // Wyrenderuj szablon