<?php
declare(strict_types=1);                                  // Użyj ścisłej kontroli typów
include '../../src/bootstrap.php';                        // Dołącz plik konfiguracyjny

$sukces = $_GET['sukces'] ?? null;                        // Sprawdź wiadomość o sukcesie
$niepowodzenie = $_GET['niepowodzenie'] ?? null;          // Sprawdź wiadomość o niepowodzeniu

$kategorie = $cms->pobierzKategorie()->pobierzWszystko(); // Pobierz wszysktie kategorie
?>
<?php include APP_ROOT . '/public/dolaczane/admin-naglowek.php'; ?>
<main class="container" id="content">
  <section class="header">
    <h1>Kategorie</h1>
    <?php if ($sukces) { ?>
      <div class="alert alert-success"><?= $sukces ?></div>
    <?php } ?>
    <?php if ($niepowodzenie) { ?>
      <div class="alert alert-danger"><?= $niepowodzenie ?></div>
    <?php } ?>
    <p><a href="kategoria.php" class="btn btn-primary">Dodaj nową kategorię</a></p>
  </section>

  <table class="categories">
    <tr>
      <th>Nazwa</th>
      <th class="edit">Zmień</th>
      <th class="del">Usuń</th>
    </tr>
    <?php foreach ($kategorie as $kategoria) { ?>
      <tr>
        <td><strong><?= zastap_html($kategoria['nazwa']) ?></strong></td>
        <td><a href="kategoria.php?id=<?= $kategoria['id'] ?>"
               class="btn btn-primary">Zmień</a></td>
        <td><a href="usun-kategorie.php?id=<?= $kategoria['id'] ?>"
               class="btn btn-danger">Usuń</a></td>
      </tr>
    <?php } ?>
  </table>
</main>
<?php include APP_ROOT . '/public/dolaczane/admin-stopka.php'; ?>