<?php
class Strona
{
  // atrybuty klasy Strona
  public $zawartosc;
  public $tytul = "TLA CONSULTING";
  public $slowa_kluczowe = "TLA Consulting, Tutaj Lubią Atrybuty,
                       niektóre z moich najlepszych przyjaciółek to wyszukiwarki";
  public $przyciski = array("Strona główna" => "glowna.php",
                            "Kontakt"       => "kontakt.php",
                            "Usługi"        => "uslugi.php",
                            "Mapa strony"   => "mapa.php"
                           );

  // operacje klasy Strona
  public function __set($nazwa, $wartosc)
  {
    $this->$nazwa = $wartosc;
  }

  public function Wyswietl()
  {
    echo "<html>\n<head>\n";
    $this->WyswietlTytul();
    $this->WyswietlSlowaKluczowe();
    $this->WyswietlStyle();
    echo "</head>\n<body>\n";
    $this->WyswietlNaglowek();
    $this->WyswietlMenu($this->przyciski);
    echo $this->zawartosc;
    $this->WyswietlStopke();
    echo "</body>\n</html>\n";
  }

  public function WyswietlTytul()
  {
    echo "<title> $this->tytul </title>";
  }

  public function WyswietlSlowaKluczowe()
  {
    echo "<meta name=\"keywords\" content=\"".$this->slowa_kluczowe."\" />";
  }

  public function WyswietlStyle()
  {
    ?>   
    <link href="style.css" type="text/css" rel="stylesheet">
    <?php
  }

public function WyswietlNaglowek()
  {
?>
    <!-- nagłówek strony -->
    <header>    
      <img src="logo.gif" alt="TLA logo" height="70" width="70" /> 
      <h1>TLA Consulting</h1>
    </header>
<?php
  }

  public function WyswietlMenu($przyciski)
  {
    echo "<!-- menu -->
    <nav>";

    while (list($nazwa, $url) = each($przyciski)) {
      $this->WyswietlPrzycisk($nazwa, $url, 
               !$this->CzyToAktualnyURL($url));
    }
    echo "</nav>\n";
  }

  public function CzyToAktualnyURL($url)
  {
    if(strpos($_SERVER['PHP_SELF'], $url)==false)
    {
      return false;
    }
    else
    {
      return true;
    }
  }

  public function WyswietlPrzycisk($nazwa, $url, $active = true)
  {
    if ($active) { ?>
      <div class="menuitem">
        <a href="<?=$url?>">
        <img src="m-logo.gif" alt="" height="20" width="20" />
        <span class="menutext"><?=$nazwa?></span>
        </a>
      </div>
      <?php
    } else { ?>
      <div class="menuitem">
      <img src="boczne-logo.gif">
      <span class="menutext"><?=$nazwa?></span>
      </div>
      <?php
    }  
  }

  public function WyswietlStopke()
  {
?>
    <!-- stopka strony -->
    <footer>
      <p>&copy; TLA Consulting<br />
      Prosimy odwiedzić
      <a href="prawne.php">stronę informacji prawnych</a>.</p>
    </footer>
<?php
  }
}
?>
