<?php

function tworz_naglowek_html($tytul = '') {
  // wyświetlenie nagłówka HTML

  // zadeklarowanie zmiennych sesji zastosowanych w funkcji

  if(!$_SESSION['produkty']) {
    $_SESSION['produkty'] = '0';
  }
  if(!$_SESSION['calkowita_wartosc']) {
    $_SESSION['calkowita_wartosc'] = '0.00';
  }
?>
  <html>
  <head>
    <meta charset="UTF-8" />
    <title><?php echo $tytul; ?></title>
    <style>
      h2 { font-family: Arial, Helvetica, sans-serif; font-size: 22px; color = red; margin = 6px }
      body { font-family: Arial, Helvetica, sans-serif; font-size: 13px }
      li, td { font-family: Arial, Helvetica, sans-serif; font-size: 13px }
      hr { color: #FF0000; width=70%; text-align=center}
      a { color: #000000 }
    </style>
  </head>
  <body>
  <table width="100%" border="0" cellspacing = "0" bgcolor="#cccccc">
  <tr>
  <td rowspan = "2">
  <a href = "index.php"><img src="obrazki/ksiazkorama.gif" alt="Książkorama" border="0"
       align="left" valign="bottom" height = "55" width = "325"/></a>
  </td>
  <td align = "right" valign = "bottom">
  <?php
    if(isset($_SESSION['uzyt_admin'])) {
       echo "&nbsp;";
    } else {
       echo "Ilość produktów = ".$_SESSION['produkty'];
    }
  ?>
  </td>
  <td align = "right" rowspan = "2" width = "135">
  <?php
    if(isset($_SESSION['uzyt_admin'])) {
       wyswietl_przycisk('wylog.php', 'wylogowanie', 'Wylogowanie');
    } else {
       wyswietl_przycisk('pokaz_kosz.php', 'zobacz-kosz', 'Widok koszyka na zakupy');
      }
  ?>
  </tr>
  <tr>
  <td align = "right" valign = "top">
  <?php
    if(isset($_SESSION['uzyt_admin'])) {
       echo "&nbsp;";
    } else {
       echo "Wartość = PLN ".number_format($_SESSION['calkowita_wartosc'],2);
    }
  ?>
  </td>
  </tr>
  </table>
<?php
  if($tytul) {
    tworz_tytul_html($tytul);
  }
}

function tworz_stopke_html() {
  // wyświetlenie stopki HTML
?>
  </body>
  </html>
<?php
}

function tworz_tytul_html($naglowek) {
  // wyświetlenie nagłówka
?>
  <h2><?php echo $naglowek; ?></h2>
<?php
}

function tworz_html_url($url, $nazwa) {
  // wyświetlenie URL-a jako łącza i nowa linia
?>
  <a href="<?php echo $url; ?>"><?php echo $nazwa; ?></a><br />
<?php
}

function wyswietl_kategorie($tablica_kat) {
  if (!is_array($tablica_kat)) {
     echo "<p>Brak dostępnych kategorii</p>";
     return;
  }
  echo "<ul>";
  foreach ($tablica_kat as $rzad) {
    $url = "pokaz_kat.php?idkat=".urlencode($rzad['idkat']);
    $tytul = $rzad['nazwakat'];
    echo "<li>";
    tworz_html_url($url, $tytul);
    echo "</li>";
  }
  echo "</ul>";
  echo "<hr />";
}

function wyswietl_ksiazki($tablica_ksiazek) {
  //wyświetlenie wszystkich książek z przekazanej tablicy
  if (!is_array($tablica_ksiazek)) {
     echo "<p>Brak aktualnie dostępnych książek w tej kategorii</p>";
  } else {
    //stworzenie tabeli
    echo "<table width = \"100%\" border = \"0\">";

    //stworzenie wiersza tabeli dla każdej książki
    foreach ($tablica_ksiazek as $rzad)
    {
      $url = "pokaz_ksiazke.php?isbn=".($rzad['isbn']);
      echo "<tr><td>";
      if (@file_exists("obrazki/".$rzad['isbn'].".jpg")) {
        $tytul = "<img src=\"obrazki/".($rzad['isbn']).".jpg\"
                  style=\"border: 1px solid black\"/>";
        tworz_html_url($url, $tytul);
      } else {
        echo "&nbsp;";
      }
      echo "</td><td>";
      $tytul =  $rzad['tytul'].', autor '.$rzad['autor'];
      tworz_html_url($url, $tytul);
      echo "</td></tr>";
    }
    echo "</table>";
  }
  echo "<hr />";
}

function wyswietl_dane_ksiazki($ksiazka) {
  // wyświetlenie wszystkich danych konkretnej książki
  if (is_array($ksiazka)) {
    echo "<table><tr>";
    //wyświetlenie obrazka jeżeli istnieje
    if (@file_exists("obrazki/".($ksiazka['isbn']).".jpg")) {
      $wielkosc = GetImageSize("obrazki/".$ksiazka['isbn'].".jpg");
      if(($wielkosc[0] > 0) && ($wielkosc[1] > 0)) {
        echo "<td><img src=\"obrazki/".$ksiazka['isbn'].".jpg\" style=\"border: 1px solid black\"/></td";
      }
    }
    echo "<td><ul>";
    echo "<li><strong>Autor:</strong> ";
    echo $ksiazka['autor'];
    echo "</li><li><strong>ISBN:</strong> ";
    echo $ksiazka['isbn'];
    echo "</li><li><strong>Cena:</strong> ";
    echo number_format($ksiazka['cena'], 2);
    echo "</li><li><strong>Opis:</strong> ";
    echo $ksiazka['opis'];
    echo "</li></ul></td></tr></table>";
  } else {
    echo "Dane tej książki nie mogą zostać wyświetlone w tym momencie.";
  }
  echo "<hr />";
}

function wyswietl_form_kasy() {
  // wyświetlenie formularza pobierającego adres
?>
  <br />
  <table border = "0" width = "100%" cellspacing = "0">
  <form action = "zakup.php" method = "post">
  <tr><th colspan = "2" bgcolor="#cccccc">Dane klienta:</th></tr>
  <tr>
    <td>Nazwisko</td>
    <td><input type = "text" name = "nazwisko" value = "" maxlength = "40" size = "40"/></td>
  </tr>
  <tr>
    <td>Adres</td>
    <td><input type = "text" name = "adres" value = "" maxlength = "40" size = "40"/></td>
  </tr>
  <tr>
    <td>Miasto</td>
    <td><input type = "text" name = "miasto" value = "" maxlength = "20" size = "40"/></td>
  </tr>
  <tr>
    <td>Województwo</td>
    <td><input type = "text" name = "wojew" value = "" maxlength = "20" size = "40"/></td>
  </tr>
  <tr>
    <td>Kod pocztowy</td>
    <td><input type = "text" name = "kod_poczt" value = "" maxlength = "10" size = "40"/></td>
  </tr>
  <tr>
    <td>Kraj</td>
    <td><input type = "text" name = "kraj" value = "" maxlength = "20" size = "40"/></td>
  </tr>
  <tr><th colspan = "2" bgcolor="#cccccc">Adres dostawy (proszę zostawić puste jeżeli taki sam jak powyższy)</th></tr>
  <tr>
    <td>Nazwisko</td>
    <td><input type = "text" name = "dos_nazwisko" value = "" maxlength = "40" size = "40"/></td>
  </tr>
  <tr>
    <td>Adres</td>
    <td><input type = "text" name = "dos_adres" value = "" maxlength = "40" size = "40"/></td>
  </tr>
  <tr>
    <td>Miasto</td>
    <td><input type = "text" name = "dos_miasto" value = "" maxlength = "20" size = "40"/></td>
  </tr>
  <tr>
    <td>Województwo</td>
    <td><input type = "text" name = "dos_wojew" value = "" maxlength = "20" size = "40"/></td>
  </tr>
  <tr>
    <td>Kod pocztowy</td>
    <td><input type = "text" name = "dos_kod_poczt" value = "" maxlength = "10" size = "40"/></td>
  </tr>
  <tr>
    <td>Kraj</td>
    <td><input type = "text" name = "dos_kraj" value = "" maxlength = "20" size = "40"/></td>
  </tr>
  <tr>
    <td colspan = "2" align = "center">
      <p><strong>Proszę nacisnąć przycisk "Zakup" w celu dokonania zakupu
         lub "Kontynuacja zakupów" w celu zmiany zamówienia</strong></p>
     <?php wyswietl_form_przycisk("zakup", "Zakupienie tych produktów"); ?>
    </td>
  </tr>
  </form>
  </table><hr />
<?php
}

function wyswietl_dostawe($dostawa) {
  // wyświetlenie kosztów dostawy i całkowitej wartości
  global $_SESSION;
?>
  <table border = "0" width = "100%" cellspacing = "0">
  <tr><td align = "left">Dostawa</td>
      <td align = "right"> <?php echo number_format($dostawa, 2); ?></td></tr>
  <tr><th bgcolor="#cccccc" align = "left">Wartość razem z dostawą</th>
      <th bgcolor="#cccccc" align = "right">PLN <?php echo number_format($dostawa+$_SESSION['calkowita_wartosc'], 2); ?></th>
  </tr>
  </table><br />
<?php
}

function wyswietl_form_karty($nazwisko) {
  // wyświetlenie formularza karty
?>
  <table border = "0" width = "100%" cellspacing = "0">
  <form action = "przetworz.php" method = "post">
  <tr><th colspan = "2" bgcolor="#cccccc">Szczegóły karty kredytowej</th></tr>
  <tr>
    <td>Typ</td>
    <td><select name = "typ_karty">
        <option value="VISA">VISA</option>
        <option value="MasterCard">MasterCard</option>
        <option value="American Express">American Express</option>
        </select>
    </td>
  </tr>
  <tr>
    <td>Numer</td>
    <td><input type = "text" name = "numer_karty" value = "" maxlength = "16" size = "40"/></td>
  </tr>
  <tr>
    <td>kod AMEX (jeżeli wymagany)</td>
    <td><input type = "text" name = "kod_amex" value = "" maxlength = "4" size = "4"/></td>
  </tr>
  <tr>
    <td>Data ważności</td>
    <td>Miesiąc
      <select name = "miesiac_karty">
      <option value="01">01</option>
      <option value="02">02</option>
      <option value="03">03</option>
      <option value="04">04</option>
      <option value="05">05</option>
      <option value="06">06</option>
      <option value="07">07</option>
      <option value="08">08</option>
      <option value="09">09</option>
      <option value="10">10</option>
      <option value="11">11</option>
      <option value="12">12</option>
      </select>
      Rok
      <select name = "rok_karty">
      <?php
      for ($y = date("Y"); $y < date("Y") + 10; $y++) {
         echo "<option value=\"".$y."\">".$y."</option>";
       }
       ?>
      </select>
  </tr>
  <tr>
    <td>Nazwisko na karcie</td>
    <td><input type = "text" name = "nazwa_karty" value = "<?php echo $nazwisko; ?>" maxlength = "40" size = "40"></td>
  </tr>
  <tr>
    <td colspan = "2" align = "center">
      <p><strong>Proszę nacisnąć przycisk "Kupuj" w celu dokonania zakupu
         lub "Kontynuuj zakupy" w celu zmiany zamówienia</strong></p>
     <?php wyswietl_form_przycisk('zakup', 'Zakup tych produktów'); ?>
    </td>
  </tr>
  </table>
<?php
}



function wyswietl_koszyk($koszyk, $zmiana = true, $obrazki = 1) {
  // wyświetlenie zawartości koszyka
  // opcjonalnie pozwala na zmiany (true lub false)
  // opcjonalnie dołącza obrazki(1 — tak, 0 — nie)

  echo "<table border = \"0\" width = \"100%\" cellspacing = \"0\">
        <form action = \"pokaz_kosz.php\" method = \"post\">
        <tr><th colspan = \"". (1+$obrazki) ."\" bgcolor=\"#cccccc\">Produkt</th>
        <th bgcolor=\"#cccccc\">Cena</th>
        <th bgcolor=\"#cccccc\">Ilość</th>
        <th bgcolor=\"#cccccc\">Wartość</th>
        </tr>";

  // wyświetlanie każdego produktu jako wiersza tabeli
  foreach ($koszyk as $isbn => $ilosc) {
    $ksiazka = pobierz_dane_ksiazki($isbn);
    echo "<tr>";
    if($obrazki ==true) {
      echo "<td align = \"left\">";
      if (file_exists("obrazki/{$isbn}.jpg")) {
         $wielkosc = GetImageSize("obrazki/{$isbn}.jpg");
         if(($wielkosc[0] > 0) && ($wielkosc[1] > 0)) {
           echo "<img src=\"obrazki/".htmlspecialchars($isbn).".jpg\"
                 style=\"border:1px solid black\"
                 width = \"".($wielkosc[0]/3) ."\"
                 height = \"" .($wielkosc[1]/3) . "\"/>";
         }
      } else {
         echo "&nbsp;";
      }
      echo "</td>";
    }
    echo "<td align = \"left\">
          <a href = \"pokaz_ksiazke.php?isbn=".urlencode($isbn)."\">".htmlspecialchars($ksiazka['tytul'])."</a>, 
            autor ".htmlspecialchars($ksiazka['autor'])."</td>
          <td align = \"center\">PLN ".number_format($ksiazka['cena'], 2)."</td>
          <td align = \"center\">";
    // jeżeli zmiany są dozwolone, ilości znajdują się w polach tekstowych
    if ($zmiana == true) {
      echo "<input type=\"text\" name=\"".htmlspecialchars($isbn)."\" value=\"".htmlspecialchars($ilosc)."\" size=\"3\">";
    } else {
      echo $ilosc;
    }
    echo "</td><td align=\"center\">PLN ".number_format($ksiazka['cena']*$ilosc,2)."</td></tr>\n";
  }
  // wyświetl wiersz sumy
  echo "<tr>
          <th colspan= \"". (2+$obrazki) ." bgcolor=\"#cccccc\">&nbsp;</td>
          <th align= \"center\" bgcolor=\"#cccccc\">
              ".htmlspecialchars($_SESSION['produkty'])."
          </th>
          <th align= \"center\" bgcolor=\"#cccccc\">
              PLN ".number_format($_SESSION['calkowita_wartosc'], 2)."
          </th>
        </tr>";
  // wyświetl przycisk zapisujący zmiany
  if($zmiana == true) {
    echo "<tr>
            <td colspan=\"". (2+$obrazki) ."\">&nbsp;</td>
            <td align=\"center\">
              <input type=\"hidden\" name=\"zapisz\" value=\"true\" />
              <input type=\"image\" src=\"obrazki/zapisz-zmiany.gif\"
                     border=\"0\" alt=\"Zapisz zmiany\">
            </td>
            <td>&nbsp;</td>
        </tr>";
  }
  echo "</form></table>";
}

function wyswietl_form_log() {
  // wyświetlenie formularza logowania
?>
  <form method="post" action="admin.php">
  <table bgcolor="#cccccc">
   <tr>
     <td>Nazwa użytkownika:</td>
     <td><input type="text" name="nazwa_uz"/></td></tr>
   <tr>
     <td>Hasło:</td>
     <td><input type="password" name="haslo"/></td></tr>
   <tr>
     <td colspan="2" align="center">
     <input type="submit" value="Logowanie"/></td></tr>
   <tr>
 </table></form>
<?php
}

function wyswietl_menu_admin() {
?>
<br />
<a href="indeks.php">Główna strona</a><br />
<a href="dodaj_kat_form.php">Dodanie nowej kategorii</a><br />
<a href="dodaj_ksiazke_form.php">Dodanie nowej książki</a><br />
<a href="zmiana_hasla_form.php">Zmiana hasła administratora</a><br />
<?php

}

function wyswietl_przycisk($cel, $obrazek, $alt) {
  echo "<div align=\"center\"><a href=\"$cel\">
        <img src=\"obrazki/$obrazek".".gif\"
        alt=\"".$alt."\" border=\"0\" height = \"50\"
        width = \"135\"></a></div>";
}

function wyswietl_form_przycisk($obrazek, $alt) {
  echo "<div align=\"center\"><input type = \"image\"
        src=\"obrazki/$obrazek".".gif\"
        alt=\"".$alt."\" border=\"0\" height = \"50\"
        width = \"135\"/></center>";
}

?>