<?php
// Ten plik zawiera funkcje wyorzystywane przez interfejs administratora
// koszyka aplikacji Książk-o-rama

function wyswietl_form_kategorii($kategoria = '') {
// wyświetlenie formularza kategorii
// Formularz ten może zostać wykorzystany do dodawania lub edycji książek.
// Aby dodać, nie przekazywać żadnych parametrów. Ustawi to zmienną $edycja
// na false, a formularz zostanie przekazany do dodaj_kat.php.
// Aby uaktualnić, przekazać tablicę zawierającą kategorię
// Formularz zostanie wyświetlony ze starymi danymi i będzie wskazywał na
// edycja_kat.php. Doda również przycisk „Edycja kategorii"

  // jeżeli przekazana istniejąca kategoria, „tryb edycji”
  $edycja = is_array($kategoria);

  // większość formularza to czysty HTML z pewnymi fragmentami PHP
?>
  <form method="post"
      action="<?php echo $edycja?'edycja_kat.php':'dodaj_kat.php'; ?>">
  <table border="0">
  <tr>
    <td>Nazwa Kategorii:</td>
    <td><input type="text" name="nazwakat" size="40" maxlength="40"
          value="<?php echo $edycja?$kategoria['nazwakat']:''; ?>" /></td>
   </tr>
  <tr>
    <td <?php if (!$edycja) { echo "colspan=2";} ?> align="center">
      <?php
        if ($edycja) {
           echo "<input type=\"hidden\" name=\"idkat\"
                value=\"".$kategoria['idkat']."\" />";
        }
      ?>
      <input type="submit"
       value="<?php echo $edycja?'Uaktualnienie':'Dodanie'; ?> kategorii" /></form>
     </td>
     <?php
       if ($edycja) {
       // umożliwienie usunięcia istniejącej kategorii
          echo "<td>
                <form method=\"post\" action=\"usun_kat.php\">
                <input type=\"hidden\" name=\"idkat\" value=\"".$kategoria['idkat']."\" />
                <input type=\"submit\" value=\"Usuń kategorię\" />
                </form></td>";
       }
     ?>
  </tr>
  </table>
<?php
}

function wyswietl_form_ksiazki($ksiazka = '') {
// Wyświetlenie formularza książki.
// Bardzo podobny do formularza kategorii.
// Formularz ten może zostać wykorzystany do dodawania lub edycji książek.
// Aby dodać, nie przekazywać żadnych parametrów. Ustawi to zmienną $edycja
// na false, a formularz zostanie przekazany do dodaj_ksiazke.php.
// Aby uaktualnić, przekazać tablicę zawierającą książkę
// Formularz zostanie wyświetlony ze starymi danymi i będzie wskazywał na
// edycja_ksiazki.php. Doda również przycisk „Edycja książki”

  // jeżeli przekazana istniejąca książka, „tryb edycji”
  $edycja = is_array($ksiazka);

  // większość formularza to czysty HTML z pewnymi fragmentami PHP
?>
  <form method="post"
        action="<?php echo $edycja?'edycja_ksiazki.php':'dodaj_ksiazke.php';?>">
  <table border="0">
  <tr>
    <td>ISBN:</td>
    <td><input type="text" name="isbn"
         value="<?php echo htmlspecialchars($edycja ? $ksiazka['isbn'] : ''); ?>" /></td>
  </tr>
  <tr>
    <td>Tytuł książki:</td>
    <td><input type="text" name="tytul"
         value="<?php echo htmlspecialchars($edycja ? $ksiazka['tytul'] : ''); ?>" /></td>
  </tr>
  <tr>
    <td>Autor książki:</td>
    <td><input type="text" name="autor"
         value="<?php echo htmlspecialchars($edycja ? $ksiazka['autor'] : ''); ?>" /></td>
   </tr>
   <tr>
      <td>Kategoria:</td>
      <td><select name="idkat">
      <?php
          // lista możliwych kategorii pochodzi z bazy danych
          $tablica_kat=pobierz_kategorie();
          foreach ($tablica_kat as $takat) {
               echo "<option value=\"". htmlspecialchars($takat['idkat'])."\"";
               // jeżeli istniejąca książka, umieszczenie w aktualnej kategorii
               if (($edycja) && ($takat['idkat'] == $ksiazka['idkat'])) {
                   echo " wybrano";
               }
               echo ">". htmlspecialchars($takat['nazwakat'])."</option>";
          }
          ?>
          </select>
        </td>
   </tr>
   <tr>
    <td>Cena:</td>
    <td><input type="text" name="cena"
               value="<?php echo htmlspecialchars($edycja ? $ksiazka['cena'] : ''); ?>" /></td>
   </tr>
   <tr>
     <td>Opis:</td>
     <td><textarea rows="3" cols="50"
          name="opis">
          <?php echo htmlspecialchars($edycja ? $ksiazka['opis'] : ''); 
          ?></textarea></td>
    </tr>
    <tr>
      <td <?php if (!$edycja) { echo "colspan=2"; }?> align="center">
         <?php
            if ($edycja)
             // potrzebny jest stary isbn, aby znaleźć książkę w bazie danych
             // jeżeli isbn jest uaktualniany
             echo "<input type=\"hidden\" name=\"staryisbn\"
                    value=\"". htmlspecialchars($ksiazka['isbn'])."\" />";
         ?>
        <input type="submit"
               value="<?php echo $edycja?'Uaktualnienie':'Dodanie'; ?> książki" />
        </form></td>
        <?php
           if ($edycja) {
             echo "<td>
                   <form method=\"post\" action=\"usun_ksiazke.php\">
                   <input type=\"hidden\" name=\"isbn\"
                    value=\"". htmlspecialchars($ksiazka['isbn']) ."\" />
                   <input type=\"submit\" value=\"Usuń książkę\" />
                   </form></td>";
            }
          ?>
         </td>
      </tr>
  </table>
  </form>
<?php
}

function wyswietl_haslo_form() {
// wyświetlenie formularza html do zmiany hasła
?>
   <br />
   <form action="zmiana_hasla.php" method=post>
   <table width="250" cellpadding="2" cellspacing="0" bgcolor="#cccccc">
   <tr><td>Dotychczasowe hasło:</td>
       <td><input type="password" name="stare_haslo" size="16" maxlength="16" /></td>
   </tr>
   <tr><td>Nowe hasło:</td>
       <td><input type="haslo" name="nowe_haslo" size="16" maxlength="16" /></td>
   </tr>
   <tr><td>Powtórz nowe hasło:</td>
       <td><input type="password" name="nowe_haslo2" size="16" maxlength="16" /></td>
   </tr>
   <tr><td colspan="2" align="center"><input type="submit" value="Zmiana hasła">
   </td></tr>
   </table>
   <br />
<?php
};

function dodaj_kat($nazwakat) {
// dodaje nową kategotię do bazy danych
   $lacz = lacz_bd();

   // sprawdzenie, czy kategoria juz nie istnieje
   $zapytanie = "select *
                from kategorie
                where nazwakat='".$nazwakat."'";
   $wynik = mysql_query($zapytanie);
   if ((!$wynik) || (mysql_num_rows($wynik)!=0)) {
     return false;
   }

   // dodanie nowej kategorii
   $zapytanie = "insert into kategorie values
            ('', '".$nazwakat."')";
   $wynik = mysql_query($zapytanie);
   if (!$wynik) {
     return false;
   } else {
     return true;
   }
}

function dodaj_ksiazke($isbn, $tytul, $autor, $idkat, $cena, $opis) {
// dodanie nowej książki do bazy danych

   $lacz = lacz_bd();

   // sprawdzenie, czy książka juz nie istnieje
   $zapytanie = "select *
             from ksiazki
             where isbn='".$isbn."'";

   $wynik = mysql_query($zapytanie);
   if ((!$wynik) || (mysql_num_rows($wynik)!=0)) {
     return false;
   }

   // dodanie nowej ksiazki
   $zapytanie = "insert into ksiazki values
            ('".$isbn."', '".$autor."', '".$tytul."', '".$idkat."', '".$cena."', '".$opis."')";

   $wynik = mysql_query($zapytanie);
   if (!$wynik) {
     return false;
   } else {
     return true;
   }
}

function uakt_kat($idkat, $nazwakat) {
// zmiana nazwy kategorii w bazie danych o danym identyfikatorze kategorii

   $lacz = lacz_bd();

   $zapytanie = "update kategorie
             set nazwakat='".$nazwakat."'
             where idkat='".$idkat."'";

             echo $zapytanie;

//   $wynik = @mysql_query($zapytanie);
$wynik = mysql_query($zapytanie);
   if (!$wynik) {
     return false;
   } else {
     return true;
   }
}

function uakt_ksiazke($staryisbn, $isbn, $tytul, $autor, $idkat, $cena, $opis) {
// zmiana danych książki o ISBN danym w $staryisbn
// nowe dane w argumentach

   $lacz = lacz_bd();

   $zapytanie = "update ksiazki
             set isbn='".$isbn."',
             tytul ='".$tytul."',
             autor = '".$autor."',
             idkat = '".$idkat."',
             cena = '".$cena."',
             opis = '".$opis."'
             where isbn='".$staryisbn."'";

   $wynik = @mysql_query($zapytanie);
   if (!$wynik) {
     return false;
   } else {
     return true;
   }
}

function usun_kategorie($idkat) {
// Usunięcie kategorii o idkat z bazy danych
// Jeżeli w kategorii znajdują się książki, nie zostanie ona
// usunięta, a funkcja zwróci false.

   $lacz = lacz_bd();

   // sprawdzenie, czy w kategorii znajdują się książki
   // w celu uniknięcia anomalii
   $zapytanie = "select * from ksiazki
                 where idkat='".$idkat."'";
   $wynik = @$lacz->query($zapytanie);
   if ((!$wynik) || (@$wynik->num_rows > 0)) {
     return false;
   }

   $zapytanie = "delete fromkategorie
             where idkat='".$idkat."'";
   $wynik = @$lacz->query($zapytanie);
   if (!$wynik) {
     return false;
   } else {
     return true;
   }
}


function usun_ksiazke($isbn) {
// Usuwa książkę o danym ISBN z bazy danych

   $lacz = lacz_bd();

   $zapytanie = "delete from ksiazki
             where isbn='".$isbn."'";
   $wynik = @mysql_query($zapytanie);
   if (!$wynik) {
     return false;
   } else {
     return true;
   }
}

?>