<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8" />
  <title>Wysyłanie...</title>
</head>
<body>
  <h1>Wysyłanie pliku...</h1>

<?php

  if ($_FILES['plikuzytkownika']['error'] > 0)
  {
    echo 'Problem: ';
    switch ($_FILES['plikuzytkownika']['error'])
    {
      case 1: 
          echo 'Rozmiar pliku przekroczył wartość upload_max_filesize'; 
          break;
      case 2: 
          echo 'Rozmiar pliku przekroczył wartość max_file_size'; 
          break;
      case 3: 
          echo 'Plik przesłany tylko częściowo'; 
          break;
      case 4: 
          echo 'Nie wysłano żadnego pliku'; 
          break;
      case 6: 
          echo 'Nie można wysłać pliku: Nie wskazano katalogu tymczasowego.'; 
          break;
      case 7: 
          echo 'Wysłani e pliku nie powiodło się: Nie zapisano pliku na dysku.'; 
          break;
      case 8:
          echo 'Rozszerzenie PHP zablokowało odebranie pliku na serwerze.';
          break;          
    }
    exit;
  }

  // czy plik ma prawidłowy typ MIME?
  if ($_FILES['plikuzytkownika']['type'] != 'image/png')
  {
    echo 'Problem: plik nie był obrazkiem w formacie PNG.';
    exit;
  }

  // umieszczenie pliku w pożądanej lokalizacji
  $lokalizacja = '/wyslane/'.$_FILES['plikuzytkownika']['name'];

  if (is_uploaded_file($_FILES['plikuzytkownika']['tmp_name']))
  {
     if (!move_uploaded_file($_FILES['plikuzytkownika']['tmp_name'], $lokalizacja))
     {
        echo 'Problem: Plik nie może być skopiowany do katalogu';
        exit;
     }
  }
  else
  {
    echo 'Problem: możliwy atak podczas wysyłania pliku. Nazwa pliku: ';
    echo $_FILES['plikuzytkownika']['name'];
    exit;
  }

  echo 'Plik został prawidłowo przesłany na serwer.';

  // wyświetlenie przesłanego obrazka
  echo '<p>Został przesłany następujący obrazek:<br/>';
  echo '<img src="/wyslane/'.$_FILES['plikuzytkownika']['name'].'"/>';
?>
</body>
</html>