<?php
  class MyArray implements ArrayAccess, Countable {
      private $_data = array();
  
  	/* ArrayAccess interface */
      public function offsetSet($offset, $value) {
        $this->_data[$offset] = $value;
      }
  
      public function offsetExists($offset) {
        return isset($this->_data[$offset]);
      }
  
      public function offsetUnset($offset) {
        unset($this->_data[$offset]);
      }
  
      public function offsetGet($offset) {
        //return (isset($this->_data[$offset])) ? $this->_data[$offset] : null;
        return ($this->offsetExists($offset)) ? $this->_data[$offset] : null;
      }
  
  	/* Countable Interface */
      public function count() {
        return count($this->_data);
      }
  
  }
  
  $a = new MyArray();
  $a[0] = 'I';
  $a[1] = 'II';
  $a[2] = 'III';
  $a[3] = 'IV';
  for ($i = 0; $i < count($a); $i++) {
    printf('<p>%s</p>', htmlspecialchars($a[$i]));
  }
?>