<?php
  function setCookieData($arr) {
    $formdata = getCookieData();
    if ($formdata == null) {
      $formdata = array();
    }
    foreach ($arr as $name => $value) {
      $formdata[$name] = $value;
    }
    setcookie('formdata', serialize($formdata), time()+30*24*60*60);
  }

  function getCookieData() {
    if (isset($_COOKIE['formdata'])) {
      $formdata = $_COOKIE['formdata'];
      if ($formdata != '') {
        if (get_magic_quotes_gpc()) {
          $formdata = stripslashes($formdata);
        }
        return unserialize($formdata);
      } else {
        return array();
      }
    } else {
      return null;
    }
  }

  function getFormDataPOST($name) {
    if (isset($_POST[$name])) {
      return $_POST[$name];
    } else {
      $cookiedata = getCookieData();
      if ($cookiedata != null && 
        isset($cookiedata[$name])) {
        return $cookiedata[$name];
      }
    }
    return '';
  }
  function getFormDataArrayPOST($name) {
    if (isset($_POST[$name])) {
      return $_POST[$name];
    } else {
      $cookiedata = getCookieData();
      if ($cookiedata != null && 
        isset($cookiedata[$name])) {
        return $cookiedata[$name];
      }
    }
    return array();
  }
  
  function getFormDataGET($name) {
    if (isset($_GET[$name])) {
      return $_GET[$name];
    } else {
      $cookiedata = getCookieData();
      if ($cookiedata != null && 
        isset($cookiedata[$name])) {
        return $cookiedata[$name];
      }
    }
    return '';
  }
  function getFormDataArrayGET($name) {
    if (isset($_GET[$name])) {
      return $_GET[$name];
    } else {
      $cookiedata = getCookieData();
      if ($cookiedata != null && 
        isset($cookiedata[$name])) {
        return $cookiedata[$name];
      }
    }
    return array();
  }
?>