<?

if(!$nazwisko||!$wynik)
{
    echo "<h1>Bd:</h1>Strona zostaa wywoana nieprawidowo";
}
else
{ 
    // generowanie nagwkw, ktre pomog przegldarce w wyborze odpowiedniej  
    // aplikacji
    header( "Content-type: application/pdf" );
    header( "Content-Disposition: attachment; filename=cert.pdf");
    
    $data = date( "F d, Y" );

    // utworzenie dokumentu pdf w pamici
    $pdf = pdf_open();

    // konfiguracja rozmiaru strony w punktach
    // US letter ma rozmiary 11" x 8.5"
    // mniej wicej 72 punkty tworz cal
    $szerokosc = 11*72;
    $wysokosc = 8.5*72; 

    pdf_begin_page($pdf, $szerokosc, $wysokosc);

    // narysowanie obwdki

    $wciecie = 20; // odstp miedzy obwdk i krawdzi strony
    $obwodka = 10; // szerokosc gwnej obwdki
    $wnetrze = 2; // przerwa w obwdce

    //narysowanie zewntrznej obwdki
    pdf_rect($pdf, $wciecie-$wnetrze, 
                   $wciecie-$wnetrze, 
                   $szerokosc-2*($wciecie-$wnetrze), 
                   $wysokosc-2*($wciecie-$wnetrze));
    pdf_stroke($pdf);

    //narysowanie gwnej obwdki o szerokoci $obwodka stopni
    pdf_setlinewidth($pdf, $obwodka);
    pdf_rect($pdf, $wciecie+$obwodka/2, 
                   $wciecie+$obwodka/2, 
                   $szerokosc-2*($wciecie+$obwodka/2), 
                   $wysokosc-2*($wciecie+$obwodka/2));
    pdf_stroke($pdf);
    pdf_setlinewidth($pdf, 1.0);

    //narysowanie wewntrznej obwdki
    pdf_rect($pdf, $wciecie+$obwodka+$wnetrze, 
                   $wciecie+$obwodka+$wnetrze, 
                   $szerokosc-2*($wciecie+$obwodka+$wnetrze), 
                   $wysokosc-2*($wciecie+$obwodka+$wnetrze));
    pdf_stroke($pdf);
     
    //dodanie tekstu
    pdf_set_font($pdf, "Times-Roman", 48, "host");
 
    $startx = ($szerokosc - pdf_stringwidth($pdf, "Certyfikat PHP"))/2;
    pdf_show_xy($pdf, "Certyfikat PHP", $startx, 490);
        
    pdf_set_font($pdf, "Times-Roman", 26, "host");
    $startx = 70;

    pdf_show_xy($pdf, "Zaswiadcza sie, ze:", $startx, 430);
    pdf_show_xy($pdf, strtoupper($nazwisko), $startx+90, 391);

    pdf_set_font($pdf, "Times-Roman", 20, "host");

    pdf_show_xy($pdf, "zademonstrowal swoje umiejetnosci ".
                      "i zdal trudny egzamin", $startx, 340);
    pdf_show_xy($pdf, "skladajacy sie z trzech pytan quizowych.", 
                       $startx, 310);

    pdf_show_xy($pdf, "$nazwisko osiagnal wynik $wynik"."%.", $startx, 260);

    pdf_show_xy($pdf, "Test zostal przeprowadzony przez", $startx, 210);
    pdf_show_xy($pdf, "Fikcyjny Instytut Certyfikacji PHP", 
                      $startx, 180);
    pdf_show_xy($pdf, "w dniu $data.", $startx, 150);

    pdf_show_xy($pdf, "Podpisano:", $startx, 100);

    // dodanie obrazka rastrowego  podpisu
    $podpis = pdf_open_image_file($pdf, "tiff", 
                                     "podpis.tif");
    pdf_place_image($pdf, $podpis, 200, 75, 1);
    pdf_close_image($pdf, $podpis);

    pdf_setrgbcolor_fill($pdf, 0, 0, .4);  //granatowy

    pdf_setrgbcolor_stroke($pdf, 0, 0, 0);  // czarny

    // narysuj pierwsz wstk
    pdf_moveto($pdf, 630, 150);
    pdf_lineto($pdf, 610, 55);
    pdf_lineto($pdf, 632, 69);
    pdf_lineto($pdf, 646, 49);
    pdf_lineto($pdf, 666, 150);
    pdf_closepath($pdf);
    pdf_fill($pdf); 

    // kontur pierwszej wstki
    pdf_moveto($pdf, 630, 150);
    pdf_lineto($pdf, 610, 55);
    pdf_lineto($pdf, 632, 69);
    pdf_lineto($pdf, 646, 49);
    pdf_lineto($pdf, 666, 150);
    pdf_closepath($pdf); 
    pdf_stroke($pdf);

    // narysuj drug wstk
    pdf_moveto($pdf, 660, 150);
    pdf_lineto($pdf, 680, 49);
    pdf_lineto($pdf, 695, 69);
    pdf_lineto($pdf, 716, 55);
    pdf_lineto($pdf, 696, 150);
    pdf_closepath($pdf);
    pdf_fill($pdf); 

    // kontur drugiej wstki
    pdf_moveto($pdf, 660, 150);
    pdf_lineto($pdf, 680, 49);
    pdf_lineto($pdf, 695, 69);
    pdf_lineto($pdf, 716, 55);
    pdf_lineto($pdf, 696, 150);
    pdf_closepath($pdf);
    pdf_stroke($pdf);

    pdf_setrgbcolor_fill($pdf, .8, 0, 0);  //czerwony
 
    //narysowanie rozetki
    rysuj_gwiazdke(665, 175, 32, 57, 10, $pdf, true);

    //kontur rozetki
    rysuj_gwiazdke(665, 175, 32, 57, 10, $pdf, false);

    pdf_end_page($pdf);
    pdf_close($pdf);

}

function rysuj_gwiazdke($srodekx, $srodeky, $ramiona, $promien, $rozmiar_ramion, $pdf, $wypelniony)
{
    $wewnetrzny_promien = $promien-$rozmiar_ramion;

    for ($i = 0; $i<=$ramiona*2; $i++ )
    {
      $kat= ($i*2*pi())/($ramiona*2);

      if($i%2)
      {
        $x = $promien*cos($kat) + $srodekx;
        $y = $promien*sin($kat) + $srodeky;
      }
      else
      {
        $x = $wewnetrzny_promien*cos($kat) + $srodekx;
        $y = $wewnetrzny_promien *sin($kat) + $srodeky;
      }
      if($i==0)
        pdf_moveto($pdf, $x, $y);
      else if($i==$ramiona*2)
        pdf_closepath($pdf);
      else
        pdf_lineto($pdf, $x, $y);
    }
    if($wypelniony)
      pdf_fill($pdf);  
    else
      pdf_stroke($pdf);

}

?>