create database ksiazka_kz;

use ksiazka_kz;

create table klienci
(
  idklienta int unsigned not null auto_increment primary key,
  nazwisko char(40) not null,
  adres char(40) not null,
  miasto char(20) not null,
  wojew char(20),
  kod_poczt char(10),
  kraj char(20) not null
);

create table zamowienia
(
  idzamowienia int unsigned not null auto_increment primary key,
  idklienta int unsigned not null,
  wartosc float(6,2),
  data date not null,
  stan_zam char(10),
  dos_nazwisko char(40) not null,
  dos_adres char(40) not null,
  dos_miasto char(20) not null,
  dos_wojew char(20),
  dos_kod_poczt char(10),
  dos_kraj char(20) not null
);

create table ksiazki
(
  isbn char(13) not null primary key,
  autor char(30),
  tytul char(60),
  idkat int unsigned,
  cena float(4,2),
  opis varchar(255)
);

create table kategorie
(
  idkat int unsigned not null auto_increment primary key,
  nazwakat char(40) not null
);

create table produkty_zamowienia
(
  idzamowienia int unsigned not null,
  isbn char(13) not null,
  cena_produktu float(4,2) not null,
  ilosc tinyint unsigned not null,
  primary key (idzamowienia, isbn)
);

create table admin
(
  nazwa_uz char(16) not null primary key,
  haslo char(16) not null
);

grant select, insert, update, delete
on ksiazka_kz.*
to ksiazka_kz@localhost identified by 'haslo';
