<?php
class ShoppingCart
{
    // kolekcja towarw umieszczonych w koszyku
    private $items;

    // inicjalizacja obiektu klasy ShoppingCart
    public function __construct()
    {
        $this->items = array();
    }

    // udostpnienie waciwoci tylko do odczytu
    public function __get($value)
    {
        switch ($value)
        {
            // contents - zwraca ca zawarto koszyka
            case 'contents':
                return $this->items;
                break;
    
            // isEmpty - wskazuje, czy koszyk jest pusty, czy nie
            case 'isEmpty':
                return (count($this->items) == 0);
                break;
    
            // totalItems - zwraca ilo typw produktw w koszyku
            case 'totalItems':
                return count($this->items);
                break;
    
            // totalQty - zwraca czn ilo towarw w koszyku
            case 'totalQty':
                return array_sum($this->items);
                break;
         }
    }

    // dodanie towaru do koszyka
    public function addItem($item, $qty = 1)
    {
        if (!$qty)
        {
            $this->removeItem($item);
        }
        else
        {
            $this->items[$item] = $qty;
        }
    }

    // zwraca ilo towarw w koszyku
    public function qtyItem($item)
    {
        if (!isset($this->items[$item]))
        {
            return 0;
        }
        else
        {
            return $this->items[$item];
        }
    }

    // czyci zawarto koszyka
    public function removeAll()
    {
        $this->items = array();
    }

    // usuwa towar z koszyka
    public function removeItem($item)
    {
        unset($this->items[$item]);
    }
}
?>
