// ustawienie widoku pocztkowego i rejestracja procedur obsugi zdarze
window.onload = function()
{
    document.getElementById('form_select').style.display = '';
    document.getElementById('form_fields').style.display = 'none';

    window.cal1 = new YAHOO.widget.Calendar("cal1", "calendar",
       { mindate: '1/1/2007',
       maxdate: '12/31/2015',
       title: 'Wybierz dat',
       close: true,
       START_WEEKDAY: 1       
       });
    window.cal1.cfg.setProperty("DATE_FIELD_DELIMITER", "-");
    window.cal1.cfg.setProperty("DATE_RANGE_DELIMITER", "/");
    window.cal1.cfg.setProperty("MDY_DAY_POSITION", 1); 
    window.cal1.cfg.setProperty("MDY_MONTH_POSITION", 2); 
    window.cal1.cfg.setProperty("MDY_YEAR_POSITION", 3); 

    window.cal1.cfg.setProperty("MD_DAY_POSITION", 1); 
    window.cal1.cfg.setProperty("MD_MONTH_POSITION", 2); 

    // etykiety dla polskich ustawie lokalnych
    window.cal1.cfg.setProperty("MONTHS_SHORT",["Sty", "Lut", "Mar", "Kwi", "Maj", "Cze", "Lip", "Sie", "Wrz", "Pa", "Lis", "Gru"]);
    window.cal1.cfg.setProperty("MONTHS_LONG",["Stycze", "Luty", "Marzec", "Kwiecie", "Maj", "Czerwiec", "Lipiec", "Sierpie", "Wrzesie", "Padziernik", "Listopad", "Grudzie"]);
    window.cal1.cfg.setProperty("WEEKDAYS_SHORT",["Nie", "Pon", "Wto", "ro", "Czw", "Pi", "Sob"]); 

    window.cal1.selectEvent.subscribe(updatePostDate, cal1, true);
    YAHOO.util.Event.addListener("show_calendar", "click",
        window.cal1.show, window.cal1, true); 
    updateCalendar();
    document.getElementById('post_date').onchange = updateCalendar;

    document.getElementById('post_id').onchange = show_form;
    document.getElementById('form_submit').onclick = submit_form;
    document.getElementById('form_reset').onclick = reset_form;
    document.getElementById('delete').onclick = submit_warning;
}

// uaktualnienie pola post_date, gdy uytkownik zmieni dat w kalendarzu
function updatePostDate(type,args,obj)
{
    var month = (args[0][0][1] < 10) ? '0' + args[0][0][1] : args[0][0][1];
    var day = (args[0][0][2] < 10) ? '0' + args[0][0][2] : args[0][0][2];
    var year = args[0][0][0];

    document.getElementById('post_date').value = day + '-' + month + '-' + year;
    window.cal1.hide();
}

// uaktualnienie daty w kalendarzu, gdy uytkownik zmieni zawarto pola post_date
function updateCalendar()
{ 
    var field = document.getElementById('post_date'); 

    if (field.value)
    { 
        window.cal1.select(field.value); 
        var selectedDates = window.cal1.getSelectedDates(); 
        if (selectedDates.length > 0)
        { 
            var firstDate = selectedDates[0]; 
            window.cal1.cfg.setProperty('pagedate',
                (firstDate.getMonth() + 1) + '-' + firstDate.getFullYear()); 
        }
    } 
    window.cal1.render(); 
}

// wywietlenie formularza, gdy uytkownik wybierze opcj zmodyfikowania strony
function show_form()
{
    fetch_info();
    document.getElementById('form_select').style.display = 'none';
    document.getElementById('form_fields').style.display = '';
    if (document.getElementById('post_id').value == 'new')
    {
        document.getElementById('delete_field').style.display = 'none';
    }
    else
    {
        document.getElementById('delete_field').style.display = '';
    }
}

// potwierdzenie, e uytkownik chce usun wpis
function submit_form()
{
    if (document.getElementById('delete').checked)
    {
        return confirm('Na pewno usun wpis?');
    }
}

// wyrnienie przycisku zapisu, jeeli rekord ma zosta usunity
function submit_warning()
{
    if (document.getElementById('delete').checked)
    {
        document.getElementById('form_submit').style.backgroundColor =
            '#FF9999';
    }
    else
    {
        document.getElementById('form_submit').style.backgroundColor = '';
    }    
}

// wyczyszczenie formularza
function reset_form()
{
    if (!confirm('Anulowa operacj?')) return false;

    document.getElementById('form_fields').style.display = 'none';
    document.getElementById('form_select').style.display = '';

    // rczne wyczyszczenie obszaru edytora
    document.getElementById('post_text').value = '';
    tinyMCE.updateContent(tinyMCE.getInstanceById('mce_editor_0').formElement.id);

    // domylnie przycisk resetowania wyczyci pola i zresetuje indeks listy,
    // zatem nie trzeba jawnie czyci formularza, jeeli tylko zwrcona zostanie
    // warto true
    return true;
}

// odczytanie danych przy uyciu "AJAX" 
var httpObj;
function fetch_info()
{
    var select = document.getElementById('post_id');
    if (select.options[select.selectedIndex].value == 'new') 
    {
        return;
    }

    var url = 'fetch_admin.php?post_id=' +
         select.options[select.selectedIndex].value + "&nocache=" +
         (new Date()).getTime();

    httpObj = createXMLHTTPObject();
    httpObj.open('GET', url, true);
    httpObj.onreadystatechange = function()
    {
        // wypenienie pl
        if (httpObj.readyState == 4 && httpObj.responseText)
        {
            var r = eval('(' + httpObj.responseText + ')');

            document.getElementById('post_title').value = r.post_title;
            document.getElementById('post_date').value = r.post_date;
            updateCalendar();
            document.getElementById('post_text').value = r.post_text;
            tinyMCE.updateContent(tinyMCE.getInstanceById('mce_editor_0').formElement.id);
        }
    }
    httpObj.send(null);
}
