<?php
include '../lib/common.php';
setlocale(LC_ALL, 'pl_PL', 'polish_pol');

// odczytanie parametru przekazanego w adresie URL
$timestamp = (isset($_GET['t'])) ? $_GET['t'] : time();

// odczytanie informacji na temat wskazanego miesica
list($month, $day, $year) = explode('/', date('m/d/Y', $timestamp));
$first_day_of_month = date('w', mktime(0, 0, 0, $month, 1, $year));
$total_days = date('t', $timestamp);

// wygenerowanie nagwka tabeli
ob_start();
echo '<table id="calendar">';
echo '<tr id="calendar_header"><th colspan="7">';
echo '<a href="' . htmlspecialchars($_SERVER['PHP_SELF']) . '?t=' .
    strtotime('-1 month', $timestamp) . '">&lt;</a> &nbsp;';
echo strtoupper(strftime('%B', $timestamp)) . ' ' . $year;
echo '&nbsp; <a href="' . htmlspecialchars($_SERVER['PHP_SELF']) . '?t=' .
    strtotime('+1 month', $timestamp) . '">&gt;</a>';
echo '</th></tr>';
echo '<tr><th>Pon</th><th>Wto</th><th>ro</th><th>Czw</th>' .
    '<th>Pi</th><th>Sob</th><th>Nie</th></tr>';

// wygenerowanie komrek dla poszczeglnych dni
$current = 1;
while ($current <= $total_days)
{
    echo '<tr class="calendar_dates">';
    for ($i = 1; $i < 8; $i++)
    {
        if (($current == 1 && $i < $first_day_of_month) ||
            ($current > $total_days))
        {
            echo '<td class="empty">&nbsp</td>';
            continue;
        }

        echo '<td>' . $current . '</td>';
        $current++;
    }
    echo '</tr>';
}
echo '</table>';
$GLOBALS['TEMPLATE']['content'] = ob_get_clean();

// przypisanie stylw dla kalendarza
$GLOBALS['TEMPLATE']['extra_head'] = '<link rel="stylesheet" type="text/css" ' .
    'href="css/monthly_calendar.css"/>';

// wywietlenie strony
include '../templates/template-page.php';
?>
