#! /usr/bin/php
<?php
// doczenie kodu wspuytkowanego
include '../lib/config.php';
include '../lib/db.php';
include '../lib/POP3Client.php';

// otwarcie wiadomoci ze streszczeniami w trybie doklejania zawartoci
// lub utworzenie wiadomoci ze streszczeniami, jeli nie istnieje
$digest = fopen(QUEUE_DIR . '/digest-' . date('Ymd') . '.txt', 'a+');

// zestawienie poczenia z serwerem POP3
$pop = new POP3Client();
$pop->connect(POP3_SERVER, POP3_PORT);
$pop->user(LIST_USER) && $pop->pass(LIST_PASSWORD);

// przetwarzanie kolejnych wiadomoci znajdujcych si w skrzynce pocztowej
foreach (array_keys($pop->_list()) as $id)
{
    // pobranie wiadomoci
    $message = $pop->retr($id);

    // odczytanie nagwkw Date, From i Subject oraz znacznika rozdzielajcego
    // poszczeglne czci wiadomoci zoonej z wielu elementw
    preg_match_all('/Date: (.+)|From: (.+)|Subject: (.+)|boundary="(.+)"/',
        $message, $matches);
    $date = trim($matches[1][0]);
    $from = trim($matches[2][1]);
    $subject = trim($matches[3][2]);
    $boundary = (isset($matches[4][3])) ? $matches[4][3] : false;

    // pominicie wiadomoci pochodzcych od uytkownikw,
    // ktrzy nie s uytkownikami listy dystrybucyjnej
    $query = sprintf('SELECT EMAIL_ADDR FROM %sMAILLIST_USER WHERE ' .
        'EMAIL_ADDR = "%s"', DB_TBL_PREFIX,
        mysql_real_escape_string($from, $GLOBALS['DB']));
    $result = mysql_query($query, $GLOBALS['DB']);
    if (!mysql_num_rows($result))
    {
        mysql_free_result($result);

        $pop->dele($id);
        continue;
    }
    mysql_free_result($result);

    // wiadomoci wieloelementowe
    if ($boundary)
    {
        // podzia wiadomoci na pojedyncze elementy
        $chunks = preg_split('/' . $boundary . '/', $message);
        array_shift($chunks); // pominicie nagwkw znajdujcych si przed MIME
        array_shift($chunks); // pominicie nagwkw znajdujcych si po MIME
        array_pop($chunks);   // usunicie kocowych znakw --

        // przetworzenie elementu text/plain
        foreach ($chunks as $chunk)
        {
            list($header, $body) = explode("\r\n\r\n", $chunk, 2);
            if (strpos($header, 'Content-Type: text/plain;') !== false)
            {
                break;
            }
        }
    }
    else
    {
        // wiadomo tekstowa
        list($header, $body) = explode("\r\n\r\n", $message, 2);
    }

    // odczytanie uytkownikw, ktrzy chc otrzymywa wszystkie wiadomoci
    $query = sprintf('SELECT EMAIL_ADDR FROM %sMAILLIST_USER WHERE ' .
        'IS_DIGEST = 0', DB_TBL_PREFIX);
    $result = mysql_query($query, $GLOBALS['DB']);

    // przesanie kopii wiadomoci
    while ($user = mysql_fetch_assoc($result))
    {
        mail($user['EMAIL_ADDR'], $subject, $body,
            'From: ' . LIST_EMAIL . "\r\n" .
            'Reply-To: ' . LIST_EMAIL . "\r\n");
    }
    mysql_free_result($result);

    // dodanie wiadomoci do wiadomoci z podsumowaniem
    fwrite($digest, $subject . "\r\n");
    fwrite($digest, $from . "\r\n");
    fwrite($digest, $date . "\r\n\r\n");
    fwrite($digest, $body . "\r\n");
    fwrite($digest, str_repeat('-', 70) . "\r\n");

    // oznaczenie wiadomoci jako przeznaczonej do usunicia
    $pop->dele($id);
}

$pop->quit();
fclose($digest);
mysql_close($GLOBALS['DB']);
?>