<?php
    $host = "ldap.wjgilmore.com";

    // Kogo szukamy?
    $dn = "uid=wjgilmore,ou=People,dc=WJGilmore,dc=com";
    
    // Nawiązanie połączenia z serwerem LDAP
    $connection = ldap_connect($host)
                  or die("Nie można nawiązać połączenia LDAP");
                  
    ldap_set_option($connection, LDAP_OPT_PROTOCOL_VERSION, 3);
    
    // Powiązanie z serwerem
    ldap_bind($connection) or die("Nie można wykonać operacji powiązania.");
    
    // Pobranie poszukiwanych informacji
    $results = ldap_read($connection, $dn, '(objectclass=person)',
    array("givenName", "sn"));
    
    // Pobranie tablicy zwróconych rekordów
    $entry = ldap_get_entries($connection, $results);
    
    // Wyświetlenie imienia i nazwiska
    printf("Imię: %s <br />", $entry[0]["givenname"][0]);
    printf("Nazwisko: %s <br />", $entry[0]["sn"][0]);
    
    // Zamknięcie połączenia
    ldap_unbind($connection);
?>
