<?php
    // Inicjalizacja sesji
    session_start();
    
    // Nawiązanie połączenia z serwerem i wybór bazy danych
    $db = new mysqli("localhost", "webuser", "secret", "corporate");
    
    // Użytkownik chce przeczytać artykuł, należy go pobrać z bazy danych
    $stmt = $db->prepare("SELECT id, title, content FROM articles WHERE id = ?");
    
    $stmt->bind_param('i', $_GET['id']);
    
    $stmt->execute();
    
    $stmt->store_result();
    
    if ($stmt->num_rows == 1)
    {
        $stmt->bind_result($id, $title, $content);
    }
    
    // Dodanie tytułu i łącza do artykułu do listy
    $articleLink = "<a href='article.php?id={$id}'>{$title}</a>";
    
    if (! in_array($articleLink, $_SESSION['articles']))
        $_SESSION['articles'][] = $articleLink;
    
    // Wyświetlenie artykułu 
    echo "<p>$title</p><p>$content</p>";
    
    // Wyświetlenie listy przeczytanych artykułów
    echo "<p>Ostatnio przeczytane artykuły</p>";
    echo "<ul>";
    
    foreach($_SESSION['articles'] as $doc) {
        echo "<li>$doc</li>";
    }
    
    echo "</ul>";
?>