<?php
    $dates = array('10-10-2011', '2-17-2010', '2-16-2011',
                   '1-01-2013', '10-10-2012');
    sort($dates);

    echo "<p>Sortowanie tablicy przy użyciu funkcji sort():</p>";
    print_r($dates);
    
    natsort($dates);

    echo "<p>Sortowanie tablicy przy użyciu funkcji natsort(): </p>";
    print_r($dates);
    
    function DateSort($a, $b) {
        // Jeśli daty są równe, nic nie rób.
        if($a == $b) return 0;
        // Podział dat na komponenty
        list($amonth, $aday, $ayear) = explode('-',$a);
        list($bmonth, $bday, $byear) = explode('-',$b);
        
        // Uzupełnienie numeru miesiąca początkowym zerem, 
        // jeśli nie ma drugiej cyfry
        $amonth = str_pad($amonth, 2, "0", STR_PAD_LEFT);
        $bmonth = str_pad($bmonth, 2, "0", STR_PAD_LEFT);
        
        // Uzupełnienie numeru dnia początkowym zerem, 
        // jeśli nie ma drugiej cyfry
        $aday = str_pad($aday, 2, "0", STR_PAD_LEFT);
        $bday = str_pad($bday, 2, "0", STR_PAD_LEFT);
        
        // Ponowne połączenie dat
        $a = $ayear . $amonth . $aday;
        $b = $byear . $bmonth . $bday;
        
        // Określenie, czy data $a > daty $b
        return ($a > $b) ? 1 : -1;
    }
    
    usort($dates, 'DateSort');
    
    echo "<p>Sortowanie przy użyciu niestandardowej funkcji DateSort(): </p>";
    
    print_r($dates);
?>
