<?php 

function angle_given_sides ($opposite, $other_1, $other_2) {
   if (($opposite <= 0) || 
       ($other_1 <= 0) || 
       ($other_2 <= 0) ||
       ($opposite >= ($other_1 + $other_2)) ||
       ($other_1 >= ($opposite + $other_2)) ||
       ($other_2 >= ($other_1 + $opposite))) {
     die("Nieistniejcy trjkt podany w parametrach ".
         "angle_given_sides: $opposite, $other_1, $other_2");
   }
   else { 
     $numerator = 
       ((($other_1 * $other_1) +
          ($other_2 * $other_2)) -
         ($opposite * $opposite));
     $denominator = 2 * $other_1 * $other_2;
     return(acos($numerator / $denominator));
  }
}

function area_to_radius ($area) {
  return (sqrt ($area / M_PI));
}

function circle_intersection_area ($radius_left,
                                   $radius_right, 
                                   $distance) {
  if ($radius_right + $radius_left <= $distance) {
    return(0);
  }
  else {
    // na pocztku obliczamy miary ktw trjkta
    // utworzonego przez dwa promienie i odlego
    // midzy rodkami okrgw
    $left_sector_angle = 
      angle_given_sides($radius_right, $radius_left,
                        $distance);
    $right_sector_angle = 
      angle_given_sides($radius_left, $radius_right,
                        $distance);
    
    // test kta rozwartego --- kt czci okrgu moe 
    // by rozwarty, ale kt trjkta nie powinien by.
    // Zapamitanie wyniku jako znaku dla kocowych 
    // oblicze pola                    

    if ($left_sector_angle < M_PI / 2) {
      $left_triangle_angle = $left_sector_angle;
      $left_triangle_sign = 1;
    }
    else {
      $left_triangle_angle = M_PI - $left_sector_angle;
      $left_triangle_sign = -1;
    }
    if ($right_sector_angle < M_PI / 2) {
      $right_triangle_angle = $right_sector_angle;
      $right_triangle_sign = 1;
    }
    else {
      $right_triangle_angle = M_PI - $right_sector_angle;
      $right_triangle_sign = -1;
    }

    // nastpnie obliczenie wysokoci tego trjkta, przy 
    // zaoeniu, e odcinek czcy rodki k jest podstaw

    $height = ($radius_left / sin(M_PI_2)) *
              sin($left_triangle_angle);
    $base_left = ($radius_left / sin(M_PI_2)) *
                  sin(M_PI_2 - $left_triangle_angle);
    $base_right = ($radius_right / sin(M_PI_2)) *
                  sin(M_PI_2 - $right_triangle_angle);

    // na kocu obliczenie pl trjkta i wycinka koa oraz
    // odpowiednie ich odjcie (lub dodanie) w celu otrzymania
    // pola przecicia. Pomnoenie przez 2 odpowiadajce obliczeniu
    // pl po dwch stronach odcinka czcego rodki
    // okrgw

    $left_triangle_area = $base_left * $height / 2;
    $right_triangle_area = $base_right * $height / 2;
    $left_sector_area = 
       ($left_sector_angle / (2 * M_PI)) *
       (M_PI * $radius_left * $radius_left);
    $right_sector_area = 
       ($right_sector_angle / (2 * M_PI)) *
       (M_PI * $radius_right * $radius_right);

    $intersection_area = 2 *
       (($left_sector_area - 
           ($left_triangle_sign * $left_triangle_area)) +
        ($right_sector_area - 
           ($right_triangle_sign * $right_triangle_area)));

    return($intersection_area);
  }
}

?>
