<?php
// Wczenie plikw z kodem, rozpoczcie sesji
include_once("certainty_utils.php");
include_once("game_display_class.php");
session_start();

// Okrelenie stanu i obsuga argumentw POST

try {

  // PRZYPADEK 1: Gracz przesya imi do listy najlepszych wynikw
  if (get_session_value('game') &&
      get_post_value('HIGHSCORE')) {
    if (get_session_value('game') &&
      get_post_value('HIGHSCORE')) {
      $game_display = 
      new GameDisplay(get_session_value('game'));
                      $game_display->handleHighScore();
    }
  }

  // PRZYPADEK 2: Gracz jest w trakcie gry, ktr ledzimy
  elseif (get_session_value('game') &&
          !get_post_value('NEW')) {
    $lower = get_post_value('lower');
    $upper = get_post_value('upper');
    $game_display = 
      new GameDisplay(get_session_value('game'));
    $game_display->updateWithAnswer($lower, $upper);
  }

  // PRZYPADEK 3: Gracz wanie zaczyna gr albo 
  // skoczy i prosi o now
  elseif (!get_post_value('POSTCHECK') ||
          get_post_value('NEW')) {
    $game_display = new GameDisplay(new Game());
  }

  // PRZYPADEK 4:  Co jest le
  // Strona jest wynkiem wynikiem wykonania operacji POST,
  // ale wydaje si, e nie ma aktywnej sesji, co oznacza
  // e nie ledzimy adnej gry.
  // Mona tylko zgosi problem i poprosi o wczenie
  // cookies
  
  else {
    $game_display = 
      new GameDisplay(new Game());
    throw (new Exception("Nie moemy skutecznie ledzi przebiegu gry." .
          "Wcz obsug cookies"));
  }

  // Budowanie napisu, ktry zostanie wywietlony jako strona
  $page_string = $game_display->display();
  // Zapisanie stanu gry w sesji, eby nastpna strona
  // moga go uy
    set_session_value('game',
      $game_display->_game);

} // koniec bloku try

catch (Exception $exception) {
  // Wystpi jaki problem. Przygotowujemy
  // stron z informacj o bdzie
  $exception_msg = $exception->getMessage();
  $display = new GameDisplay(null);  
  $page_string = 
    $display->makeErrorPage($exception_msg);
  // Nastpnym razem zaczynamy od pocztku  
  unset_session_value('game');
}

// Wywietlenie strony w przegldarce

  echo($page_string);

?>
