<?php
include_once("certainty_utils.php");
include_once("game_parameters_class.php");
include_once("question_class.php");

class Game 
{

  public $currentQuestion = NULL;
  public $previousQuestion = NULL;
  public $gameParameters;

  public $_dbConnection = NULL;
  public $_credit = 0.0;
  public $_level;
  public $_questionIdsAtLevel;  // tablica identyfikatorw
  public $_questionsAskedAtLevel = 0; // licznik
  public $_totalQuestions = 0;
  public $_correctAnswers = 0;
  public $_gameLost = FALSE;
  public $_gameWon = FALSE;

  // KONSTRUKTOR
  function __construct () {
    $this->gameParameters = new GameParameters();
    $this->_dbConnection =
      $this->gameParameters->getDbConnection();
    if (!$this->_dbConnection) {
       throw new Exception("Brak poczenia z baz danych");
    }
    else {   
      $this->_correctAnswers = 0;
      $this->_level = 
        $this->gameParameters->getStartingLevel();
      $this->_credit = 
        $this->gameParameters->getStartingCredit();
      // utwrz list pyta, ktre maj by zadane
      // na pocztkowym poziomie  
      $this->_setupQuestionIds();
      // pobierz pierwsze pytanie
      $this->_installQuestion();
    }
  }

  // FUNKCJE PUBLICZNE
  // akcesory
  function getGameParameters() 
    {return($this->gameParameters);}

  function getCurrentQuestion() 
    {return($this->currentQuestion);}

  function getPreviousQuestion() 
    {return($this->previousQuestion);}

  function getCredit() {return($this->_credit);}

  function getLevel() {return($this->_level);}

  function getQuestionsAskedAtLevel()
    {return($this->_questionsAskedAtLevel);}

  function getTotalQuestions() 
    {return($this->_totalQuestions);}

  function getCorrectAnswers()
    {return($this->_correctAnswers);}

  function getGameLost()     
    {return($this->_gameLost);}

  function getGameWon()     
    {return($this->_gameWon);}

  function getCurrentQuestionText() {
    if (!is_object($this->currentQuestion)) {
      print("Co to jest?<BR>");
      print_r($this->currentQuestion);
    }
    else {
      return($this->currentQuestion->getQuestion());
    }
  }

  function previousQuestionCorrect() {
    return($this->previousQuestion->getCorrect());
  }

  function getDbConnection () {
    if (!$this->_dbConnection) {
      $this->_dbConnection =
        $this->gameParameters->getDbConnection();
    }
    return($this->_dbConnection);
  }

  function updateWithAnswer ($lower, $upper) {
    // Gwna funkcja modyfikujca, dla obiektu game
    // Pobiera podany przez gracza przedzia, okrela
    // czy odpowied jest poprawna, aktualizuje wynik,
    // okrela, czy gracz przeszed do nastpnego poziomu
    // i wymienia pytanie na nastpne
    $this->previousQuestion = $this->currentQuestion; 
    $this->previousQuestion->updateWithAnswer($lower, 
                                              $upper);
    $this->_updateScores();    
    $this->_maybeChangeLevel();
    if (!($this->_gameLost || $this->_gameWon)) {
      $this->_installQuestion();
    }
  }

  // FUNKCJE PRYWATNE
  function _installQuestion () {
    // pobiera pytanie z bazy danych
    // i tworzy odpowiedni obiekt klasy Question
    if (count($this->_questionIdsAtLevel) > 0) {
      // wyjmuje pytanie z losowej listy
      $question_id = 
        array_pop($this->_questionIdsAtLevel);
      $query = 
        "select id, question, answer,
         upper_limit, lower_limit, scaling_type
         from question
         where id = $question_id";
      if (!$this->_dbConnection) {
        $this->_dbConnection =
          $this->gameParameters->getDbConnection();
      }
      if ($this->_dbConnection &&
          is_resource($this->_dbConnection)) {
          $result = mysql_query($query, 
                            $this->_dbConnection);
        if ($row = mysql_fetch_assoc($result)) {
          $this->currentQuestion =
             new Question(
               $row['id'],
               $row['question'],
               $row['answer'],
               $row['lower_limit'],
               $row['upper_limit'],
               10,
               $row['scaling_type']);
          $this->_questionsAskedAtLevel++;
        }
        else {
	  throw new 
            Exception("Problem przy pobieraniu pytania z bazy danych");
        }
      }
      else {
        throw new 
            Exception("Problem z zapytaniem do bazy danych");
      }
    }
    else {
      throw new 
          Exception("Brak pyta");
    }
  }

  function _setupQuestionIds () {
    $this->_questionIdsAtLevel =
      $this->_getQuestionIdsAtLevel($this->_level);
  }

  function _getQuestionIdsAtLevel ($level) {
    // do uywania w chwili przejcia na nowy poziom
    // pobiera nowe identyfikatory (same) wszystkich 
    // pyta na danym poziomie i ustawia je w losowym porzdku
    $return_array = array();
    $query = "select id from question 
              where level = $level";
    $this->getDbConnection();
    if (!$this->_dbConnection) {
      throw new 
          Exception("Brak poczenia z baz danych");
    }
    else {
      $result = mysql_query($query, 
                            $this->_dbConnection);
      while ($row = mysql_fetch_assoc($result)) {
        array_push($return_array, $row['id']);
      }
    }
    // dobranie losowego porzdku pyta
    $return_array = create_randomized_array($return_array);
    return($return_array);
  }

  public function _updateScores () {
    // Zmienia aktualny wynik opierajc si na tym
    // czy gracz poda dobr odpowied oraz na 
    // dugoci podanego przedziau. 
    // Obliczenia zale od ustawie znajdujcych si
    // w GameParameters
  
    if ($this->previousQuestion->rightAnswer()) {
      $this->_correctAnswers = 
        $this->_correctAnswers + 1;
      $this->_credit +=
        $this->gameParameters->getRightAnswerCredit() -
        ($this->previousQuestion->getAnswerSpread() *
         $this->gameParameters->getAnswerSpreadDebit());
    }
    else {
      $new_credit = 
      $this->_credit = 
        $this->_credit -
        $this->gameParameters->getWrongAnswerDebit();
    }
    // wymuszenie ograniczenia kredytu
    $this->_credit = 
      min($this->_credit, 
          $this->gameParameters->getMaximumCredit());
  }

  function _maybeChangeLevel () {
    if ($this->_credit < 0.0) {
      $this->_gameLost = TRUE;
    }
    else {
      $params = $this->gameParameters;
      $current_level = $this->_level;
      if ($current_level > 
          $params->getMaximumLevel()) {
        $this->_gameWon = TRUE;
      }
      else {
        // sprawdza, czy zostao jakie pytanie
        // do zadania na tym poziomie
        if (($this->_questionsAskedAtLevel >=
             $params->getQuestionsPerLevel($current_level)) ||
            (count($this->_questionIdsAtLevel) == 0)) {
              // albo osignlimy limit pyta 
              // na poziom, albo si skoczyy
              $this->_level++;
              $this->_questionsAskedAtLevel = 0;
              $this->_setupQuestionIds();
              // wywoanie rekursywne --- moe si zdarzy,
              // e nie znaleziono wicej pyta, a musimy
              // kontynuowa
              $this->_maybeChangeLevel();
        }
      }   
    }
  }

  function __sleep () {
    // serializowane s wszystkie pola, oprcz 
    // poczenia z baz danych (bo musi by na nowo tworzone)
    // oraz poprzedniego pytania (bo nie ma sensu)
    return(array(
           'gameParameters',
           'currentQuestion',
           '_credit',
           '_level',
           '_questionIdsAtLevel',
           '_questionsAskedAtLevel',
           '_correctAnswers',
           '_totalQuestions',
           '_gameLost',
           '_gameWon'));
  }
}
?>
