<?php

/***************************************************************
 * To jest edytor produktw.                                   *
 * Celem tego narzdzia jest edycja wszystkich danych          *
 * pprzypisannych do pojedynczego produktu.  Bdzie on gwnie *
 * uywany do naprawiania bahych bdw (np. pisowni)         *
 **************************************************************/

include("oci8_funcs.php"); //wsplne funkcje na narzdzi na bazie Oracle
$thisDB = "dev";
$thisDBuser = "oci_user";
$thisDBpassword = "sesame";

// ----------------------
// Edycja danych produktu
// ----------------------
if($_POST['submit'] == "Submit") {
   // Pobierz znacznik czasowy 
   $begin_time = time();
   // Otwrz poczenie
   $conn = OCILogon($thisDBuser, $thisDBpassword, $thisDB) or die("Nie mona utworzy poczenia z baz danych.");

   // Uaktualnienie tabeli produktw
   $product_id = $_POST['product_id'];
   $product_name = escape_sq($_POST['product_name']);
   $sku = escape_sq($_POST['sku']);
   $itemurl = escape_sq($_POST['itemurl']);
   $itemimage = escape_sq($_POST['itemimage']);
   $desc_text = escape_sq($_POST['desc_text']);

   $query = "UPDATE product 
             SET product_name = '$product_name',
                 sku = '$sku',
                 itemurl = '$itemurl',
                 itemimage = '$itemimage',
                 desc_text = '$desc_text',
                 modified = SYSDATE
             WHERE product_id = $product_id";
   $stmt = parse_exec_free($conn, $query, &$error_str);
   if (!$stmt) {
      die_silently($conn, $error_str);
   }

   // Uaktualnienie tabeli PRODUCT_ATTRIB_VAL
   // Na pocztek pozbywamy si istniejcych wierszy tego produktu
   $query = "DELETE FROM product_attrib_val
             WHERE product_id = $product_id";
   $stmt = parse_exec_free($conn, $query, &$error_str);
   if (!$stmt) {
      die_silently($conn, $error_str);
   }
   if (is_array($_POST['attrib']) && count($_POST['attrib']) > 0) {
      foreach ($_POST['attrib'] as $attrib_id=>$av_id_array) {
         if (is_array($av_id_array) && count($av_id_array) > 0) {
            foreach ($av_id_array as $attrib_val_id) {
              // Dodaj nowe wiersze jeli wartoci atrybutu nie jest Delete All
               if ($attrib_val_id != -1) {
                  $query = "INSERT INTO product_attrib_val (attrib_val_id, product_id, modified, created)
                            VALUES($attrib_val_id, $product_id, SYSDATE, SYSDATE)";
                  $stmt = parse_exec_free($conn, $query, &$error_str);
                      if (!$stmt) {
                     die_silently($conn, $error_str);
                      }
                 }
              }
         }
      }
   }

   OCICommit($conn);
   OCILogoff($conn);
   
   /*
   // Moesz usun te komentarze dla tego bloku w procesie debuggowania
   // Pobierz drugi znacznik czasowy i wykonaj dopasowanie
   $end_time = time();
   echo "Zrobione!  Operacja zabraa ".($end_time - $begin_time) ." sekund do ukoczenia.";
   exit;
   */

   // Wywietl ponownie formularz
   header("Location:  $PHP_SELF?url=$prod_url");
}


// ---------------
// Poka formularz
// ---------------
elseif (!isSet($_POST['submit']) || $_POST['submit'] != "Submit") {
   set_time_limit(0);
   // Pobierz znacznik czasowy
   $begin_time = time();
   // Otwrz poczenie
   $conn = OCILogon($thisDBuser, $thisDBpassword, $thisDB) or die("Nie mona utworzy poczenia z baz danych.");

   // Pobierz dane o produkcie bazujc na unikalnym adresie URL przekazanym przez GET   
$url = $_GET['url'];
   if ($url == "") {
      // Jeli URL nie moe by przekazane, wywietl wiadomo i wyjd
      echo "<HTML>\n<BODY>";
      echo '<P>Musisz wyznaczy produkt do edycji przez podanie adresu url takiego jak:  http://localhost/tools/prod_point.php?url=book_PHP4_Bible.</P>';
      echo "</BODY>\n</HTML>";
      exit;
   }
   $query = "SELECT product_id, product_name, sku, itemurl, itemimage, desc_text, category_id
             FROM product
             WHERE url = '$url'";
   $stmt = parse_exec_fetch($conn, $query, &$error_str, &$res);
   if (!$stmt) {
      die_silently($conn, $error_str);
   } else {
      OCIFreeStatement($stmt);
      $product_id = $res['PRODUCT_ID'][0];
      $product_name = $res['PRODUCT_NAME'][0];
      $sku = $res['SKU'][0];
      $itemurl = $res['ITEMURL'][0];
      $itemimage = $res['ITEMIMAGE'][0];
      $desc_text = $res['DESC_TEXT'][0];
      $category_id = $res['CATEGORY_ID'][0];
   }


   // Pobierz atrybuty dla wszystkich produktw w tej kategorii
   $query = "SELECT attribute_id, attribute_name
             FROM attribute
             WHERE category_id = $category_id";
   $stmt = parse_exec_fetch($conn, $query, &$error_str, &$res1);
   if (!$stmt) {
      die_silently($conn, $error_str);
      exit;
   } else {
      OCIFreeStatement($stmt);
   }
   if (is_array($res1['ATTRIBUTE_ID']) && count($res1['ATTRIBUTE_ID']) > 0) {
      foreach ($res1['ATTRIBUTE_ID'] as $key=>$attrib_id) {
          $attrib_name = $res1['ATTRIBUTE_NAME'][$key];
        // Pobierz wartoci attrib dla tego produktu
        $query = "SELECT product_attrib_val.attrib_val_id
                   FROM product_attrib_val, attrib_val
                   WHERE product_attrib_val.attrib_val_id = attrib_val.attrib_val_id
                   AND attrib_val.attrib_id = $attrib_id
                   AND product_attrib_val.product_id = $product_id";
        $stmt = parse_exec_fetch($conn, $query, &$error_str, &$res2);
        if (!$stmt) {
            die_silently($conn, $error_str);
        } else {
           OCIFreeStatement($stmt);
           // Pobierz wszystkie moliwe wartoci atrybutu dla tego atrybutu
           // i utwrz pikne, rozwijane menu
           $query = "SELECT attrib_val_id, name
                      FROM attrib_val
                      WHERE attrib_id = $attrib_id
                      ORDER BY name";
           $stmt = parse_exec_fetch($conn, $query, &$error_str, &$res3);
           if (!$stmt) {
               die_silently($conn, $error_str);
           } else {
              OCIFreeStatement($stmt);
              // Fragment dla poniszego Przypadku 2
              $is_vals = $res2['ATTRIB_VAL_ID'];
              $num_is_vals = count($is_vals);
              $poss_vals = $res3['ATTRIB_VAL_ID'];
              $num_poss_vals = count($poss_vals);
              $nonmatching = array_diff($poss_vals, $is_vals);

              if ($num_poss_vals > 0) {
                foreach ($poss_vals as $av_key=>$avalue_id) {
                   $av_name = $res3['NAME'][$av_key];
                   // Istniejce wartoci s wybrane w tej licie.
                   // Przypadek 0:  nie podwietlaj niczego jeli nie ma adnych wartoci atrybutu
                   if (!is_array($is_vals) || $num_is_vals == 0) {
                       $av_str .= "<OPTION VALUE=\"$avalue_id\">$av_name</OPTION>\n";
                   }
                   // Przypadek 1: pojedyncza warto atrybutu
                   elseif ($num_is_vals == 1) {
                      if ($is_vals[0] == $avalue_id) {
                        $av_str .= "<OPTION VALUE=\"$avalue_id\" SELECTED>$av_name</OPTION>\n";
                     } else {
                        $av_str .= "<OPTION VALUE=\"$avalue_id\">$av_name</OPTION>\n";
                      }
                   }
                   // Przypadek 2: wiele wartoci atrybutw
                   // Troch pomieszane poniewa chciaem unikn wielu
                   // niepasujcych opcji
                   elseif ($num_is_vals > 1) {
                       foreach ($is_vals as $avid) {
                       if ($avid == $avalue_id) {
                          $av_array[] = "<OPTION VALUE=\"$avalue_id\" SELECTED>$av_name</OPTION>";
                       }
                    }
                    if (count($nonmatching) > 0) {
                       foreach ($nonmatching as $avid){
                          if ($avid == $avalue_id) {
                            $av_array[] = "<OPTION VALUE=\"$avalue_id\">$av_name</OPTION>";
                          }
                       }
                    }
                     $av_str = implode("\n", $av_array);
                  }
               }
             }
           }
          $attrib_str .= "$attrib_name ($num_is_vals):  <SELECT NAME=\"attrib[$attrib_id][]\" SIZE=5 MULTIPLE>\n<OPTION VALUE='-1'>Usu wszystko</OPTION>\n$av_str</SELECT><BR><BR>\n";
          unset($av_array);
          unset($av_str);
        }
      }
   }
   OCILogoff($conn);


   // ------------------
   // Wywietl formularz
   // ------------------
   $php_self = $_SERVER['PHP_SELF']; // Superglobals nie dziaaj z heredoc
$form_str = <<< EOFORMSTR
<HTML>
<HEAD>
<TITLE>Edytor Produktu</TITLE>
<STYLE>
<!--
.header    {font-family: verdana, arial, sans-serif; font-size: 14pt; font-weight: bold; color: #000000; text-align: left}
.subheader    {font-family: verdana, arial, sans-serif; font-size: 12pt; font-weight: bold; color: #000000; background: #ebeef1; text-align: left}
-->
</STYLE>
</HEAD>

<BODY BGCOLOR="#FFFFFF">
<P class="header">Edytor produktu</P>

<P>Baz danych jest <B>$thisDB</B></P>

<P><B>DANE PRODUKTU</B></P>
<FORM ACTION="$php_self" METHOD="post">
<INPUT TYPE=HIDDEN NAME="product_id" VALUE="$product_id">
Nazwa:  <INPUT TYPE=TEXT NAME="product_name" SIZE=30 VALUE="$product_name"><BR><BR>
SKU #:  <INPUT TYPE=TEXT NAME="sku" SIZE=70 VALUE="$sku"><BR><BR>
Adres URL:  <INPUT TYPE=TEXT NAME="itemurl" SIZE=70 VALUE="$itemurl"><BR><BR>
Obrazek:  <INPUT TYPE=TEXT NAME="itemimage" SIZE=70 VALUE="$itemimage"><BR><BR>
Opis:  <TEXTAREA NAME="desc_text" COLS=50 ROWS=5>$desc_text</TEXTAREA><BR><BR>

<P><B>ATRYBUTY</B></P>
$attrib_str
<INPUT TYPE=SUBMIT NAME="submit" VALUE="Submit">
</FORM>
</BODY>
</HTML>
EOFORMSTR;
   echo $form_str;

   // Pobierz drugi znacznik czasowy i dopasuj
   $end_time = time();
   echo "Zrobione!  Operacja zabraa  ".($end_time - $begin_time) ." sekund do ukoczenia.<BR>\n";
}

?>
