<?php

/*********************************************
 * Funkcje dla narzdzi bazujcych na Oracle *
 ********************************************/

putenv("ORACLE_HOME=/tools/oracle");


// Uyj kiedy pobierasz dane z bazy danych
function unescape_quotes($str)
{
   $esc_str = str_replace("''", "'", $str);
   $esc2_str = str_replace("\"\"", "\"", $esc_str);
   return $esc2_str;
}


// Uyj kiedy wstawiasz dane do bazy danych
function escape_sq($str)
{
   $esc_str = str_replace("'", "''", $str);
   return $esc_str;
}


function escape_html($str)
{
   $gt_str = str_replace("&gt;", ">;", $str);
   $lt_str = str_replace("&lt;", "<", $gt_str);
   $dq_str = str_replace("&quot;", "\"", $lt_str);
   $esc_str = str_replace("&amp;", "&", $dq_str);
   return $esc_str;
}


// Uyj tego dla polece INSERT, UPDATE i DELETE
function parse_exec_free($conn, $query, &$error_str)
{
   $stmt = OCIParse($conn, $query);
   OCIExecute($stmt, OCI_DEFAULT);
   $err_array = OCIError($stmt);
   if ($err_array) {
      $err_message = $err_array['message'];
      $error_str = $err_message;
      OCIFreeStatement($stmt);
      $stmt = FALSE;
   } else {
       OCIFreeStatement($stmt);
      $stmt = TRUE;
   }
   return $stmt;
}


// Uyj tego dla polecenia SELECT
function parse_exec_fetch($conn, $query, &$error_str, &$res, $nulls=0)
{
   $stmt = OCIParse($conn, $query);
   OCIExecute($stmt, OCI_DEFAULT);
   $err_array = OCIError($stmt);
   if ($err_array) {
      $err_message = $err_array['message'];
      $error_str = $err_message;
      OCIFreeStatement($stmt);
      $stmt = FALSE;
   } else {
      if ($nulls == 1) {
         OCIFetchStatement($stmt, $res, OCI_RETURN_NULLS);
      } else {
         OCIFetchStatement($stmt, $res);
      }
   }
   return $stmt;
}


// Dla pliku batch_upload.php, ktry zapisuje oddzielny dziennik bedw
function choke_and_die($conn, $fp, $error_str)
{
   OCIRollback($conn);
   OCILogoff($conn);
   $error_line = $error_str."<BR>\n";
   echo $error_line;
   fwrite($fp, $error_line);
   fwrite($fp, "</HTML>\n");
   fclose($fp);
   exit;
}


// Dla wszystkich szybkich uy (ktre stanowi wikszo)
function die_silently($conn, $error_str)
{
   OCIRollback($conn);
   OCILogoff($conn);
   // Moesz usun te znaki komentarzy w trakcie debuggowania
   //$error_line = $error_str."<BR>\n";
   //echo $error_line;
   exit;
}


// Excel czasami dodaje przypadkowe cudzysowia wok pl z zawartoci
function unquote($str)
{
   $pos = strpos($str, "\"");
   if ($pos === 0) {
      $qstr = substr($str, 1, -1);
      return trim($qstr);
   } else {
      return trim($str);
   }
}


// Excel czasami powiela podwjny cudzysw prbujc go zamkn
function strip_db($str)
{
   $esc_str = str_replace("\"\"", "\"", $str);
   return $esc_str;
}

?>
