<?php

/********************************************************
 * Nowy produkt pobiera skrypt atrybutw.               *
 * Celem tego narzdzia jest pobranie                   *
 * arkusza kalkulacyjnego z nagwkiem danych produktu. *
 * Edytorzy bd uywa tego do dodania                 *
 * nowych przedmiotw do kategorii.  Uzyj skryptu       *
 * batch_upload_new.php aby przekaza dane.             *
 *******************************************************/

include("oci8_funcs.php"); //wsplne funkcje dla narzdzi Oracle
$thisDB = "dev";
$thisDBuser = "oci_user";
$thisDBpassword = "sesame";

// Otwrz poczenie
$conn = OCILogon($thisDBuser, $thisDBpassword, $thisDB);

// --------------------------
// Pobierz nagwek kategorii
// --------------------------
if ($_POST['submit'] == "Add") {
   // Wywoaj przechowywan procedur dla tej kategorii
   $cat_id_in = $_POST['cat_id'];
   $request = "begin DEV.get_cat_header($cat_id_in, :OUT1, :OUT2); end;";
   $cursor1 = OCINewCursor($conn);
   $cursor2 = OCINewCursor($conn);
   $stmt = OCIParse($conn, $request);
   OCIBindByName($stmt, ":OUT1", &$cursor1, -1, OCI_B_CURSOR);
   OCIBindByName($stmt, ":OUT2", &$cursor2, -1, OCI_B_CURSOR);
   OCIExecute($stmt);
   OCIExecute($cursor1);
   OCIExecute($cursor2);
   $err_array = OCIError($conn);
   if ($err_array) {
      $err_message = $err_array['message'];
      echo $err_message;
      OCIFreeCursor($cursor1);
      OCIFreeCursor($cursor2);
      OCIFreeStatement($stmt);
      OCILogoff($conn);
      exit;
   }
   while (OCIFetchInto($cursor1,&$data1)) {
      $p_array[] = $data1[1];
   }
   while (OCIFetchInto($cursor2,&$data2)) {
      $a_array[] = $data2[1]."|".$data2[0];
   }
   OCIFreeCursor($cursor1);
   OCIFreeCursor($cursor2);
   OCIFreeStatement($stmt);
   OCILogoff($conn);
   // zbierz do pobrania
   $init_p_str = implode("\t", $p_array);
   $p_str = str_replace("CATEGORY_ID", $cat_id_in, $init_p_str);
   if (count($a_array) > 0) {
      $a_str = implode("\t", $a_array);
   }
   $full_header = implode("\t", array($p_str, $a_str));

   // wylij plik
   $header_file = 'header.xls.Z';
   $zp = gzopen($header_file, "w+");
   gzwrite($zp, $full_header);
   gzclose($fp);
   header("Location:  header.xls.Z");
   // Dla IE5.x, jest to prawidowy sposb na rozpoczcie pobierania pliku
   // -- przez proste przekierowanie przegldarki na pobieranie typu pliku
   // ktrego przegldarka nie moe otworzy
}


// -----------------
// Wybr kategorii
// -----------------
elseif (!isSet($_POST['submit'])) {
   // Wywoanie przechowywanej procedury get_categories
   $request = "begin DEV.get_categories(:OUT1); end;";
   $cursor1 = OCINewCursor($conn);
   $stmt = OCIParse($conn, $request);
   OCIBindByName($stmt, ":OUT1", &$cursor1, -1, OCI_B_CURSOR);
   OCIExecute($stmt);
   OCIExecute($cursor1);
   $err_array = OCIError($conn);
   if ($err_array) {
      $err_message = $err_array['message'];
      echo $err_message;
      OCIFreeCursor($cursor1);
      OCIFreeStatement($stmt);
      OCILogoff($conn);
      exit;
   }
   while (OCIFetchInto($cursor1, &$cat_array)) {
      $opt_str .= "<OPTION VALUE=\"".$cat_array[0]."\">".$cat_array[1]."</OPTION>\n";
   }
   OCIFreeCursor($cursor1);
   OCIFreeStatement($stmt);
   OCILogoff($conn);


   // Formularz wyboru kategorii
   $php_self = $_SERVER['PHP_SELF']; // Superglobals nie dziaaj z heredoc
   $form_str = <<< EOFORMSTR
<HTML>
<HEAD>
<TITLE>Nowy edytor grupowy: Pobieranie</TITLE>
<STYLE>
<!--
.header    {font-family: verdana, arial, sans-serif; font-size: 14pt; font-weight: bold; color: #000000; text-align: left}
.subheader    {font-family: verdana, arial, sans-serif; font-size: 12pt; font-weight: bold; color: #000000; background: #ebeef1; text-align: left}
.ftrnote    {font-family: verdana, arial, sans-serif; font-size: 8pt; color: #000000; text-align: left}
LI     {line-height:200%}
-->
</STYLE>
</HEAD>

<BODY BGCOLOR="#FFFFFF">
<P class="header">Nowy edytor grupowy: Pobieranie</P>

<P>Baz danych jest <B>$thisDB</B></P>

<FORM ACTION="$php_self" METHOD="POST">
<SELECT NAME="cat_id" SIZE=1>
<OPTION VALUE="-1" SELECTED>Wybierz jeden</OPTION>
$opt_str
</SELECT><BR>
<INPUT TYPE=SUBMIT NAME="submit" VALUE="Add">
</FORM>
</BODY>
</HTML>
EOFORMSTR;

   echo $form_str;
}
?>
