<?php

/**************************************************
 * Skrypt przekazujcy nowy produkt.              *
 * Celem tego narzdzia jest przekazanie arkusza  *
 * kalkulacyjnego z danymi nowego produktu.       *
 * Edytorzy uyj go do dodania nowego przedmiotu *
 * do kategorii.  Uyj skryptu                    *
 * header_download.php aby pobra atrybuty.       *
 *************************************************/

include("oci8_funcs.php"); // wsplne funkcje dla narzdzi Oracle
$thisDB = "dev";
$thisDBuser = "oci_user";
$thisDBpassword = "sesame";


// Nagwek
$header_str = <<< ENDOFHEADER
<HTML>
<HEAD>
<TITLE>Nowy edytor grupowy: Przekazanie</TITLE>
<STYLE>
<!--
.header    {font-family: verdana, arial, sans-serif; font-size: 14pt; font-weight: bold; color: #000000; text-align: left}
.subheader    {font-family: verdana, arial, sans-serif; font-size: 12pt; font-weight: bold; color: #000000; background: #ebeef1; text-align: left}
-->
</STYLE>
</HEAD>

<BODY BGCOLOR="#FFFFFF">
<P class="header"> Nowy edytor grupowy: przekazanie </P>

<P>Baz danych jest <B>$thisDB</B></P>
ENDOFHEADER;
echo $header_str;


// Dodanie nowych produktw
if($_POST['submit'] == "Upload") {
   set_time_limit(0);
   echo "<P>Sprawd dziennik bdw (<A HREF\"upload_log.html\">upload_log.html</A>) aby zobaczy problemy.</P>";

   // Skopiowanie niezaadowanego pliku do okrelonego katalogu
   $tempfile = $HTTP_POST_FILES[file][tmp_name];
   $localfile = $HTTP_POST_FILES[file][name];
   if(!copy($tempfile, "/tmp/$localfile")) {
      echo "<P>Bd zapisu pliku do katalogu. Wyjcie.</P>\n";
      exit;
   }

   // Pocztek dziennika bdw
   $error_log = 'upload_log.html';
   $fp = fopen($error_log, "w+") or die("Nie mona otworzy dziennika bdw.");
   fwrite($fp, "<HTML>\n");

   // Otwrz poczenie
   $conn = OCILogon($thisDBuser, $thisDBpassword, $thisDB) or die("Nie mozna uzyska poczenia z baz danych.");

   // Pobierz znacznik czasowy
   $begin_time = time();

   // Odczytaj w danych pliku jak w tablicy
   $uarray = file("/tmp/$localfile");

   // Przetwrz nagwek dla cat_id i atrybutw
   $header = array_shift($uarray);
   $harray = explode("\t", $header);
   $num_ha = count($harray);
   $cat_id = $harray[0];
   $attrib_array = array();
   for($i = 6; $i <= ($num_ha - 1); $i++) {
      $a_array = explode("|", $harray[$i]);
      $attrib_array[] = $a_array[1];
   }
   $num_attribs = count($attrib_array);

   $error_str = "";
   $res = array();
   // Pobierz wszystkie wartoci atrybutw i umie je w wielowymiarowej tablicy
   foreach($attrib_array as $attrib) {
      $query = "SELECT attrib_value_id, name
                FROM attrib_value
                WHERE attrib_id = $attrib";
      $stmt = parse_exec_fetch($conn, $query, &$error_str, &$res);
      if (!$stmt) {
         choke_and_die($conn, $fp, $error_str);
      } else {
   foreach($res['NAME'] as $key => $val) {
      $ava[$attrib][$val] = $res['ATTRIB_VALUE_ID'][$key];
   }
         OCIFreeStatement($stmt);
      }
   }
   reset($attrib_array);

   // Popchnij dane przez poczenie.
   foreach ($uarray as $valrow) {
      // Pobierz nowe ID produktu z Oracle
      $query = "begin :new_id := newid('product'); end;";
      $sth = OCIParse($conn, $query);
      OCIBindByName($sth, ":new_id", &$new_id, 200);
      OCIExecute($sth);
      if (!$sth) {
         choke_and_die($conn, $fp, $error_str);
      } else {
          $rowid = $new_id;
         OCIFreeStatement($sth);
      }

      // Sformatuj dane nowego produktu.
      $val_array = explode("\t", $valrow);
      $prod_name = unquote($val_array[1]);
      $prod_name = strip_db($prod_name);
      $prod_name = escape_sq($prod_name);
echo "Pracuj nad $prod_name<BR>\n";
      $sku = unquote($val_array[2]);
      $itemurl = unquote($val_array[3]);
      $itemimage = unquote($val_array[4]);
      $desc = unquote($val_array[5]);
      $desc = escape_sq($desc);

      // PRODUKT
      $query = "INSERT INTO product (product_id, product_name, sku, itemurl, itemimage, desc, created, modified, category_id) VALUES ($rowid, '$prod_name', '$sku', '$itemurl', '$itemimage', '$desc', SYSDATE, SYSDATE, $cat_id)";
      $stmt = parse_exec_free($conn, $query, &$error_str);
      if (!$stmt) {
         choke_and_die($conn, $fp, $error_str);
      }

      // PRODUCT_ATTRIB_VALUE
      for ($i = 6; $i <= (6 + $num_attribs - 1); $i++) {
         $av = unquote($val_array[$i]);
         if($av != "") {
            $temp_q = explode("|", $av);
            foreach($temp_q as $av) {
               $av = unasterisk($av);
               $av = escape_sq($av);
                $akey = $i - 6;
                $attrib_id = $attrib_array[$akey];
                if($ava[$attrib_id][$av]) {
                    $pav = $ava[$attrib_id][$av];
                    $query = "INSERT INTO product_attrib_value (attrib_value_id, product_id, created, modified) VALUES($pav, $rowid, SYSDATE, SYSDATE)";
                    $stmt = parse_exec_free($conn, $query, &$error_str);
                    if (!$stmt) {
                     choke_and_die($conn, $fp, $error_str);
                    }
                }
            }
         } else {
            //echo "Wartoci atrybutu null.<BR>\n";
         }
      }
   }

   // Pobierz drugi znacznik czasowy i dopasuj
   $end_time = time();
   echo "Zrobione!  Operacja zabraa ".($end_time - $begin_time) ." sekund do ukoczenia.";

   OCICommit($conn);
   OCILogoff($conn);
   fwrite($fp, "</HTML>\n");
   fclose($fp);
}



// Poka formularz przekazania pliku
elseif($_POST['submit'] != "Upload") {
   $upload_str = <<< ENDOFUPLOAD
<P>Przeka dane nowego produktu:</P>
<FORM ACTION="$PHP_SELF" METHOD="post" ENCTYPE="multipart/form-data">
<INPUT TYPE=HIDDEN NAME="max_file_size" VALUE="1000000">
<INPUT TYPE=FILE NAME="file" SIZE=50><BR><BR>
<INPUT TYPE=SUBMIT NAME="submit" VALUE="Upload">
</FORM>
ENDOFUPLOAD;
   echo $upload_str;
}

?>
</BODY>
</HTML>
