<?php

function checkcard($cc, $ccType)
{
  if (!ereg("^[0-9 ]*$", $cc))
  {
    print "Numer karty moe zawiera tylko cyfry i spacje.";
    return (false);
  }

  // Usunicie spacji.
  $cc = ereg_replace('[ ]', '', $cc);

  // Sparawdzenie pierwszych czterech cyfr.
  $firstFour = intval(substr($cc, 0, 4));
  $type = "";
  $length = 0;

  if ($firstFour >= 8000 && $firstFour <= 8999)
  {
    // Wyprbuj: 8000 0000 0000 1001
    $type = "SurchargeCard";
    $length = 16;
  }
  elseif ($firstFour >= 9100 && $firstFour <= 9599)
  {
    // Wyprbuj: 9100 0000 0001 7
    $type = "AustralianExpress";
    $length = 13;
  }

  if (empty($type) || strcmp($type, $ccType) != 0)
  {
    print "Prosz sprawdzi dane karty kredytowej.";
    return (false);
  }

  if (strlen($cc) != $length)
  {
    print "Numer karty musi zawiera {$length} cyfr.";
    return (false);
  }

  $check = 0;

 // Suma co 2 cyfry, zaczynajc od prawej strony.
  for($x=$length-1;$x>=0;$x-=2)
    $check += intval(substr($cc, $x, 1));

  // Podwojona suma co 2 cyfry, zaczynajc od prawej strony - 1.
  // Jeeli podwojona warto jest wiksza od 10, odj od niej 9.
  for($x=$length-2;$x>=0;$x-=2)
  {
    $double = intval(substr($cc, $x, 1)) * 2;
    if ($double >= 10)
      $check += $double - 9;
    else
      $check += $double;
  }

  // Czy $check nie jest wielokrotnoci 10?
  if ($check % 10 != 0)
  {
    print "Karta kredytowa nieprawidowa. Prosz sprawdzi numer.";
    return (false);
  }
  return (true);
}

?>
