<?php
// Wersja PEAR listingu 9.2

require_once "Net/DNS.php";

// Wywoa z parametrem $type rwnym MX a nastpnie A, aby sprawdzi, 
// czy domena adresu e-mail jest prawidowa
function checkMailDomain($domain, $type)
{
  // Utworzenie obiektu Resolver i wyszukanie rekordu $type dla $domain
  $resolver = new Net_DNS_Resolver( );
  $answer = $resolver->search($domain, $type);

  // Czy mamy odpowied?
  if (isset($answer->answer))
    // Przegldanie odpowiedzi
    foreach($answer->answer as $ans)
      // Jeeli znaleziony typ $type funkcja zwraca true
      if ($ans->type == $type)
         return true;

  return false;
}

// Poniszy fragment realizuje to samo, ale korzysta z PEAR
function checkemailwithPEAR($email)
{
  // Kontrola skadni
  $validEmailExpr =  "^[0-9a-z~!#$%&_-]([.]?[0-9a-z~!#$%&_-])*" .
                     "@[0-9a-z~!#$%&_-]([.]?[0-9a-z~!#$%&_-])*$";

  // Kontrola adresu e-mail
  if (empty($email))
  {
    print "Pole e-mail nie moe by puste.";
    return false;
  }    
  elseif (!eregi($validEmailExpr, $email))
  {  
    print "E-mail musi by zapisany w formacie nazwa@domena.";
    return false;
  }
  elseif (strlen($email) > 30)
  { 
    print "Adres e-mail nie moe by duszy ni 30 znakw.";
    return false;
  }
  elseif (function_exists("getmxrr") && function_exists("gethostbyname"))
  {
    // Wycinanie domeny z adresu e-mail
    $maildomain = substr(strstr($email, '@'), 1);

    if (!(checkMailDomain($maildomain, "MX") || 
        checkMailDomain($maildomain, "A")))
    {
      print "Domena nie istnieje.";
      return false;
    }

  return true;
}
?>

