<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Rozszerzenie szablonu klasy ITX dla aplikacji obsugi winiarni
// -- winestoreTemplate to oglna strona
// -- winestoreFormTemplate to strona formularza (dziedziczca po winestoreTemplate)

require_once "DB.php";
require_once "HTML/Template/ITX.php";
require_once "winestore.inc";

define("P_TITLE", "Sieciowa winiarnia - Hugh i Dave");

// Rozszerzenie klasy HTML_Template_ITX dla stron winiarni
class winestoreTemplate extends HTML_Template_ITX
{
   // Konstruktor klasy.
   // aduje szablon winestore.tpl skeleton, oraz podan stron.
   // Ustawia tytu strony.
   function winestoreTemplate($pageBody, $pageTitle = P_TITLE)
   {
      $this->template = $this->HTML_Template_ITX(D_TEMPLATES);
      $this->loadTemplatefile(T_SKELETON, true, true);
      $this->setVariable("TITLE", $pageTitle);
      $this->addBlockFile("PAGE_BODY", "pageBody", "{$pageBody}");
   }

   // Koczy stron i wywietla za pomoc show()
   function showWinestore($options = NO_CART, $buttons = B_HOME)
   {
      $this->setCurrentBlock();

      // Pokazuje status zalogowania uytkownika.
      $this->showLogin();

      if ($options & ~NO_CART)
         // Pokazuje warto oraz liczb towarw w koszyku.
         $this->showCart();

      // Wywietla komunikaty.
      $this->showMessage();

      // Konfiguracja przyciskw.
      if ($buttons != 0)
         $this->showButtons($buttons);

      $this->setCurrentBlock();
      $this->parseCurrentBlock();
      $this->show();
   }

   // Pokazuje liczb oraz warto towarw w koszyku,
   // jak rwnie ikon koszyka bdc czem.
   function showCart()
   {
      global $dsn;

      $connection = DB::connect($dsn, true);

      if (DB::isError($connection))
         trigger_error($connection->getMessage(), E_USER_ERROR); 

      // Inicjalizacja pustego koszyka.
      $cartAmount = 0;
      $cartCount = 0;

      // Jeeli uytkownik doda towary do koszyka, to
      // zarejestrowana zostanie zmienna order_no will
      if (isset($_SESSION["order_no"]))
      {
         $cartQuery = "SELECT qty, price FROM items
                       WHERE cust_id = -1 
                       AND order_id = {$_SESSION["order_no"]}";

         // Obliczenie liczby i wartoci towarw w koszyku.
         // W tym celu, poprzez poczenie do bazy danych 
         // wykonywane jest zapytanie cartQuery.
         $result = $connection->query($cartQuery);

         if (DB::isError($result))
            trigger_error($result->getMessage(), E_USER_ERROR);

         while ($row = $result->fetchRow(DB_FETCHMODE_ASSOC))
         {
            $cartAmount += $row["price"] * $row["qty"];
            $cartCount += $row["qty"];          
         }
      }

      $this->setCurrentBlock("cartheader");
      $this->setVariable("I_CART_OFF", I_CART_OFF);
      $this->setVariable("I_CART_ON", I_CART_ON);
      $this->setVariable("S_SHOWCART", S_SHOWCART);   
      $this->setVariable("TOTAL", sprintf("%-.2f", $cartAmount));
      $this->setVariable("COUNT", sprintf("%d", $cartCount));
      $this->parseCurrentBlock("cartheader");
   }



   // Wywietlenie ustawionych komunikatw a nastepnie
   // ich skasowanie.
   function showMessage()
   {
      // Czy trzeba pokaza uytkownikowi komunikat bdu?
      if (isset($_SESSION["message"]))
      {
         $this->setCurrentBlock("message");
         $this->setVariable("INFO_MESSAGE", $_SESSION["message"]);
         $this->parseCurrentBlock("message");

         // Kasowanie komunikatu bdu.
         unset($_SESSION["message"]);
      }
   }

   // Pokazanie, czy uytkonik jest zalogowany, czy nie.
   function showLogin()
   {
      // Czy uytkownik jest zalogowany?
      if (isset($_SESSION["loginUsername"]))
         $this->setVariable("LOGIN_STATUS", 
                     "Jeste zalogowany jako {$_SESSION["loginUsername"]}");
      else
         $this->setVariable("LOGIN_STATUS", 
                     "Nie jeste zalogowany");
   }

   // Wywietlanie przyciskw na stronach winiarni
   function showButtons($buttons)
   {
      $this->setCurrentBlock("buttons");

      // Jeeli w koszyku znajduj si towary, umoliwiamy przegladanie
      // lub oprnianie koszyka 
      if (isset($_SESSION["order_no"]))
      {
         if ($buttons & B_EMPTY_CART)
         {
            $this->setCurrentBlock("form");
            $this->setVariable("ACTION", S_EMPTYCART);
            $this->setVariable("NAME", "empty");
            $this->setVariable("VALUE", "Oprnij koszyk");
            $this->parseCurrentBlock("form");
         }

         if ($buttons & B_SHOW_CART)
         {
            $this->setCurrentBlock("form");
            $this->setVariable("ACTION", S_SHOWCART);
            $this->setVariable("NAME", "view");
            $this->setVariable("VALUE", "Poka koszyk");
            $this->parseCurrentBlock("form");
         }

         // Uytkownik musi by zalogowany i mie towary w koszyku.
         if (($buttons & B_PURCHASE) && 
             isset($_SESSION["loginUsername"]) &&
             isset($_SESSION["order_no"]))
         {
            $this->setCurrentBlock("form");
            $this->setVariable("ACTION", S_ORDER_1);
            $this->setVariable("NAME", "purchase");
            $this->setVariable("VALUE", "Zakupy");
            $this->parseCurrentBlock("form");
         }
      }

      if ($buttons & B_SEARCH)
      {
         $this->setCurrentBlock("form");
         $this->setVariable("ACTION", S_SEARCHFORM);
         $this->setVariable("NAME", "search");
         $this->setVariable("VALUE", "Szukanie win");
         $this->parseCurrentBlock("form");
      }

      if ($buttons & B_HOME)
      {
         $this->setCurrentBlock("form");
         $this->setVariable("ACTION", S_MAIN);
         $this->setVariable("NAME", "home");
         $this->setVariable("VALUE", "Strona gwna");
         $this->parseCurrentBlock("form");
      }

      if ($buttons & B_DETAILS)
      {
         $this->setCurrentBlock("form");
         $this->setVariable("ACTION", S_DETAILS);
         if (isset($_SESSION["loginUsername"]))
         {
            $this->setVariable("NAME", "account");
            $this->setVariable("VALUE", "Zmiana danych");
         }
         else
         {
            $this->setVariable("NAME", "account");
            $this->setVariable("VALUE", "Zarejestruj si");
         }
         $this->parseCurrentBlock("form");
      }

      if ($buttons & B_LOGINLOGOUT)
      {
         $this->setCurrentBlock("form");
         if (isset($_SESSION["loginUsername"]))
         {
            $this->setVariable("ACTION", S_LOGOUT);
            $this->setVariable("NAME", "logout");
            $this->setVariable("VALUE", "Wyloguj");
         }
         else
         {
            $this->setVariable("ACTION", S_LOGIN);
            $this->setVariable("NAME", "login");
            $this->setVariable("VALUE", "Login");
         }
         $this->parseCurrentBlock("form");
      }   

      if (($buttons & B_PASSWORD) && isset($_SESSION["loginUsername"]))
      {
         $this->setCurrentBlock("form");
         $this->setVariable("ACTION", S_PASSWORD);
         $this->setVariable("NAME", "password");
         $this->setVariable("VALUE", "Zmiana hasa");
         $this->parseCurrentBlock("form");
      }

      $this->setCurrentBlock("buttons");
      $this->parseCurrentBlock("buttons");
   }


}


// Rozszerzenie klasy winestoreTemplate dla stron zawierajcych formularze.
class winestoreFormTemplate extends winestoreTemplate
{
   // Tablica formVars skojarzona z polami tej strony.
   var $formVars = null;

   // Tablica bdw skojarzona z polami tej strony.
   var $formErrors = null;

   // Konstruktor klasy.
   // Parametry:
   // (1) Nagwek w znacznikach <h1> powyej <form>
   // (2) Opis w znacznikach <b> powyej <form>
   // (3) Warto <form action="">
   // (4) Nazwa tablicy formVars $_SESSION do przechowywania wartoci pl
   // (5) Nazwa tablicy formErrors $_SESSION do przechowywania bdw w polach
   // (6) [opcjonalny] typ metody formularza
   // (7) [opcjonalny] Warto <title> dla strony
   function winestoreFormTemplate($formHeading, $instructions, 
                                  $action, $formVars, $formErrors, 
                                  $method = "POST", $pageTitle = P_TITLE)
   {
      $this->template = $this->winestoreTemplate(T_DETAILS, $pageTitle);

      // Ustawienie nagwkw dla <form> oraz skryptu docelowego.
      $this->setVariable("FORMHEADING", $formHeading);
      $this->setVariable("INSTRUCTIONS", $instructions);
      $this->setVariable("S_VALIDATE", $action);
      $this->setVariable("METHOD", $method);

      // Zapisanie formVars oraz formErrors
      $this->formVars = $formVars;
      $this->formErrors = $formErrors;
   }

   // Tworzenie obowizkowych pl formularza.
   // Parametry:
   // (1) Nazwa pola oraz odpowiadajca mu nazwa atrybutu w tablicy
   // (2) Tekst do wywietlenia w polu
   // (3) Rozmiar pola
   function mandatoryWidget($name, $text, $size)
   {
      // Czy wystpuj komunikaty bdw dotyczce tego pola?
      // Jeeli tak, wywietlenie ich ponad polem
      if (isset($_SESSION["{$this->formErrors}"]["{$name}"]))
      {
         $this->setCurrentBlock("mandatoryerror");
         $this->setVariable("MERRORTEXT", 
           $_SESSION["{$this->formErrors}"]["{$name}"]);
         $this->parseCurrentBlock("mandatoryerror");
      }

      // Konfigurowanie elementu formularza
      $this->setCurrentBlock("mandatoryinput");
      $this->setVariable("MINPUTNAME", "{$name}");
      if (isset($_SESSION["{$this->formVars}"]["{$name}"]))
         $this->setVariable("MINPUTVALUE", 
           $_SESSION["{$this->formVars}"]["{$name}"]);
      $this->setVariable("MINPUTTEXT", "{$text}");
      $this->setVariable("MINPUTSIZE", $size);
      $this->parseCurrentBlock("mandatoryinput");
      $this->setCurrentBlock("widget");
      $this->parseCurrentBlock("widget");
   }

   // Tworzenie opcjonalnych pl formularza.
   // Parametry:
   // (1) Nazwa pola oraz odpowiadajca mu nazwa atrybutu w tablicy
   // (2) Tekst do wywietlenia w polu
   // (3) Rozmiar pola
   function optionalWidget($name, $text, $size)
   {
      // Czy wystpuj komunikaty bdw dotyczce tego pola?
      // Jeeli tak, wywietlenie ich ponad polem
      if (isset($_SESSION["{$this->formErrors}"]["{$name}"]))
      {
         $this->setCurrentBlock("optionalerror");
         $this->setVariable("OERRORTEXT", 
           $_SESSION["{$this->formErrors}"]["{$name}"]);
         $this->parseCurrentBlock("optionalerror");
      }

      // Konfigurowanie elementu formularza
      $this->setCurrentBlock("optionalinput");
      $this->setVariable("OINPUTNAME", "{$name}");
      if (isset($_SESSION["{$this->formVars}"]["{$name}"]))
         $this->setVariable("OINPUTVALUE", 
           $_SESSION["{$this->formVars}"]["{$name}"]);
      $this->setVariable("OINPUTTEXT", "{$text}");
      $this->setVariable("OINPUTSIZE", $size);
      $this->parseCurrentBlock("optionalinput");
      $this->setCurrentBlock("widget");
      $this->parseCurrentBlock("widget");
   }

   // Produces a password <form> widget
   // Parameters are:
   // (1) The HTML widget name and matching table attribute name
   // (2) The text to show next to the widget
   // (3) The size of the widget
   function passwordWidget($name, $text, $size)
   {
      // Are there any errors to show for this widget?
      // If so, show them above the widget
      if (isset($_SESSION["{$this->formErrors}"]["{$name}"]))
      {
         $this->setCurrentBlock("passworderror");
         $this->setVariable("PERRORTEXT", 
           $_SESSION["{$this->formErrors}"]["{$name}"]);
         $this->parseCurrentBlock("passworderror");
      }

      // Setup the widget
      $this->setCurrentBlock("passwordinput");
      $this->setVariable("PINPUTNAME", "{$name}");
      if (isset($_SESSION["{$this->formVars}"]["{$name}"]))
         $this->setVariable("PINPUTVALUE", 
           $_SESSION["{$this->formVars}"]["{$name}"]);
      $this->setVariable("PINPUTTEXT", "{$text}");
      $this->setVariable("PINPUTSIZE", $size);
      $this->parseCurrentBlock("passwordinput");
      $this->setCurrentBlock("widget");
      $this->parseCurrentBlock("widget");
   }

   // Tworzenie elementu formularza <select>.
   // W przeciwiestwie do innych, nie obsuguje wywietlania bdw.
   // Parametry:
   // (1) Atrybuty tabeli do wypeniania wartoci <option>. Wykorzystywany rwnie 
   //     jako nazwa elementu <select> 
   // (2) Tekst wywietlany obok elementu
   // (3) Atryput tabeli wywietlany razem z <option>
   // (3) Wynik PEAR DB pozwalajcy na pobranie danych
   function selectWidget($name, $text, $optiontext, $data)
   {
      while ($row = $data->fetchRow(DB_FETCHMODE_ASSOC))
      {
         $this->setCurrentBlock("option");
         $this->setVariable("OPTIONTEXT", $row["{$optiontext}"]);
         $this->setVariable("OPTIONVALUE", $row["{$name}"]);
         if (isset($_SESSION["{$this->formVars}"]["{$name}"]) && 
             $_SESSION["{$this->formVars}"]["{$name}"] == $row["{$name}"])
            $this->setVariable("SELECTED", " selected");  
         $this->parseCurrentBlock("option");
      }
      $this->setCurrentBlock("select");
      $this->setVariable("SELECTNAME", "{$name}");
      $this->setVariable("SELECTTEXT", "{$text}");
      $this->parseCurrentBlock("select"); 
      $this->setCurrentBlock("widget");
      $this->parseCurrentBlock("widget"); 
   }
}
?>
