<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

require_once "winestore.inc";

// lad bdu
function backTrace($context)
{
   $calls = "";

   // Pobranie stosu wywoa funkcji.
   $trace = debug_backtrace();

   $calls = "\nStos wywoa:";

   // Zaczynamy od 2 -- ignorujemy t funkcj (0) oraz customHandler() (1)
   for($x=2; $x < count($trace); $x++)
   {
     $callNo = $x - 2;
     $calls .= "\n  {$callNo}: {$trace[$x]["function"]} ";
     $calls .= "(wiersz {$trace[$x]["line"]} w {$trace[$x]["file"]})";
   }

   $calls .= "\nZmienne w {$trace[2]["function"]} ():";

   // WYkorzystanie $context do odczytania informacji o zmiennych
   // dla funkcji z bdem.
   foreach($context as $name => $value)
   {
     if (!empty($value))
       $calls .= "\n  {$name} wynosi {$value}";
     else
       $calls .= "\n  {$name} wynosi NULL";
   }
   return ($calls);
}

// Wasna funkcja obsugi bdw -- taka jak w rozdziale 12.
function customHandler($number, $string, $file, $line, $context)
{
  $error = "";

  switch ($number)
  {
     case E_USER_ERROR:
       $error .= "\nBD w wierszu {$line} w {$file}.\n";
       $stop = true;
       break;
     case E_WARNING:
     case E_USER_WARNING:
       $error .= "\nOSTRZEENIE w wierszu {$line} w {$file}.\n";
       $stop = false;
       break;
     case E_NOTICE:
     case E_USER_NOTICE:
       $error .= "\nINFORMACJA w wierszu {$line} w {$file}.\n";
       $stop = false;
       break;
     default:
       $error .= "NIEOBSUONY BD w wierszu {$line} w {$file}.\n";
       $stop = false;
  }
  $error .= "Bd: \"{$string}\" (bd #{$number}).";
  $error .= backTrace($context);
  $error .= "\nIP klienta: {$_SERVER["REMOTE_ADDR"]}";

  $prepend = "\n[Bd PHP  " . date("YmdHis") . "]";
  $error = ereg_replace("\n", $prepend, $error);

  if (SCREEN_ERRORS)
     print "<pre>{$error}</pre>";

  if (FILE_ERRORS)
     error_log($error, 3, ERROR_FILE);

  if ($stop == true)
  {
    if (isset($_SESSION["order_no"]))
       unset($_SESSION["order_no"]);

   if (isset($_SESSION["loginUsername"]))
      unset($_SESSION["loginUsername"]);

   if (isset($_SESSION["loginIP"]))
      unset($_SESSION["loginIP"]);

    die(); 
  }
}

?>
