<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Skrypt usuwa towary z koszyka i kasuje zmienn sesji.

require_once "DB.php";
require_once "../includes/winestore.inc";

set_error_handler("customHandler");

// Inicjalizacja sesji - jest to niezbdne do
// skasowania sesji.
session_start();

// Czy w bazie danych znajduje si koszyk?
if (isset($_SESSION["order_no"]))
{
   $connection = DB::connect($dsn, true);
   if (DB::isError($connection))
     trigger_error($connection->getMessage(), E_USER_ERROR); 

   // Na pocztek kasujemy dane z tabeli order.
   $query = "DELETE FROM orders WHERE cust_id = -1
             AND order_id = {$_SESSION["order_no"]}";
   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 

   // Nastpnie kasujemy towary.
   $query = "DELETE FROM items WHERE cust_id = -1
             AND order_id = {$_SESSION["order_no"]}";
   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 

   // Na koniec niszczymy zmienn sesji.
   unset($_SESSION["order_no"]);
}
else
   $_SESSION["message"] = "Koszyk jest pusty.";

// Warto HTTP_REFERER nie jest ustawiana przez niektre przegldarki.
// W takim przypadku wracamy do strony gwnej.
if (isset($_SERVER["HTTP_REFERER"]))
  header("Location: {$_SERVER["HTTP_REFERER"]}");
else 
  header("Location: " . S_MAIN);
?>
