<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Skrypt wysya uytkownikowi e-mail potwierdzajcy zamwienie
// i przekierowuje go do strony z potwierdzeniem w wersji HTML.

// Domylnie skrypt korzysta z pakietu PEAR Mail.
// Aby skorzysta z wewntrznej funkcji mail(), naley zmieni "true" na "false"
// w poniszym wierszu:
define("USE_PEAR", false);

require_once "DB.php";
require_once "HTML/Template/ITX.php";
require_once "../includes/winestore.inc";
require_once "../includes/authenticate.inc";

// Skorzystaj z pakietu PEAR Mail jeeli jest zdefiniowana staa USE_PEAR.
if (USE_PEAR == true)
  require_once "Mail.php";

set_error_handler("customHandler");

// Wysanie do uytkownika poczty z podsumowaniem zakupw.
function send_confirmation_email($custID, $orderID, $connection)
{
   $template = new HTML_Template_ITX(D_TEMPLATES);
   $template->loadTemplatefile(T_EMAIL, true, true);

   // Wyszukiwanie danych klienta
   $query = "SELECT * FROM customer, users
            WHERE customer.cust_id = {$custID}
            AND users.cust_id = customer.cust_id";

   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 
   $row = $result->fetchRow(DB_FETCHMODE_ASSOC);

   // Zaczynamy od ustawienia adresu emai w polu "To:"
   $to = "{$row["firstname"]} {$row["surname"]} <{$row["user_name"]}>";

   // Teraz pola danych klienta.
   $template->setVariable("TITLE", showTitle($row["title_id"], $connection));
   $template->setVariable("SURNAME", $row["surname"]);
   $template->setVariable("CUST_ID", $custID);
   $template->setVariable("ORDER_ID", $orderID);
   $template->setVariable("FIRSTNAME", $row["firstname"]);
   $template->setVariable("INITIAL", $row["initial"]);
   $template->setVariable("ADDRESS", $row["address"]);
   $template->setVariable("CITY", $row["city"]);
   $template->setVariable("STATE", $row["state"]);
   $template->setVariable("COUNTRY", showCountry($row["country_id"], $connection));
   $template->setVariable("ZIPCODE", $row["zipcode"]);

   $orderTotalPrice = 0;

   // Wymieniamy dane na temat kadego wina w zamwieniu.
   $query = "SELECT  i.qty, w.wine_name, i.price, 
                     w.wine_id, w.year, wi.winery_name
             FROM    items i, wine w, winery wi
             WHERE   i.cust_id = {$custID}
             AND     i.order_id = {$orderID}
             AND     i.wine_id = w.wine_id
             AND     w.winery_id = wi.winery_id
             ORDER BY item_id";

   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR);

   // Dodawanie kolejnego elementu do przesyki.
   while ($row = $result->fetchRow(DB_FETCHMODE_ASSOC)) 
   { 
     // Obliczenie wartoci towarw w tym wierszu.
     $itemsPrice = $row["qty"] * $row["price"];

     $orderTotalPrice += $itemsPrice;
  
     $wineDetail = showWine($row["wine_id"], $connection);

     $template->setCurrentBlock("row");
     $template->setVariable("QTY", str_pad($row["qty"],9));
     $template->setVariable("WINE", 
                             str_pad(substr($wineDetail, 0, 53), 55));
     $template->setVariable("PRICE", 
                            str_pad(sprintf("%4.2f z" , 
                            $row["price"]), 11));
     $template->setVariable("TOTAL", 
                            str_pad(sprintf("%4.2f z", $itemsPrice), 12));
     $template->parseCurrentBlock("row");
   }

   $template->setCurrentBlock("items");
   $template->setVariable("ORDER_TOTAL", 
                          sprintf("%4.2f z\n", $orderTotalPrice));
   $template->parseCurrentBlock("items");
   $template->setCurrentBlock();
   $template->parseCurrentBlock();

   $out = $template->get();


   if (USE_PEAR == false)
   {
     // --------------------------------------------
     // Wewntrzna funkcja PHP mail() jest wykorzystywana tylko jeeli USE_PEAR ma warto false.

     // Tworzenie wiersza "Subject:"
     $subject = "Potwierdzenie zamwienia w sieciowej winiarni 'Hugh i Dave'";

     // Ustawienie nagwkw przed utworzeniem przesyki.
     $headers  = "From: Sieciowa winiarnia 'Hugh i Dave'" . 
                 "<help@webdatabasebook.com>\r\n";
     $headers .= "X-Sender: <help@webdatabasebook.com>\r\n"; 
     $headers .= "X-Mailer: PHP\r\n"; 
     $headers .= "Return-Path: <help@webdatabasebook.com>\r\n";

     // Wysanie przesyki e-mail!
     mail($to, $subject, $out, $headers);
     // --------------------------------------------
   }
   else 
   {
     // --------------------------------------------
     // Uycie pakietu PEAR Mail oraz serwera SMTP jeeli USE_PEAR ma warto true;

     // Ustawienie wiersza "Subject:"
     $headers["Subject"] = "Potwierdzenie zamwienia w sieciowej winiarni 'Hugh i Dave'";

     // Ustawienie nagwkw przed utworzeniem przesyki.
     $headers["From"] = "Sieciowa winiarnia 'Hugh i Dave' " . 
                        "<help@webdatabasebook.com>";
     $headers["X-Sender"] = "<help@webdatabasebook.com>";
     $headers["X-Mailer"] = "PHP"; 
     $headers["Return-Path"] = "<help@webdatabasebook.com>";

     $smtpMail =& Mail::factory("smtp");
     $smtpMail->send($to, $headers, $out);
     // --------------------------------------------
   }
}

// ----------

session_start();

// Podczenie do autoryzowanej sesji.
sessionAuthenticate(S_SHOWCART);

// Sprawdzenie, czy zostay przekazane prawidowe parametry.
if (!isset($_GET["cust_id"]) || !isset($_GET["order_id"]))
{
   $_SESSION["message"] = 
     "Nieprawidowe parametry skryptu order-step4.php";
   header("Location: " . S_SHOWCART);
   exit;
}      

// Sprawdzenie, czy biecy klient ma przekazan warto $cust_id
$connection = DB::connect($dsn, true);

if (DB::isError($connection))
   trigger_error($connection->getMessage(), E_USER_ERROR); 

$cust_id = pearclean($_GET, "cust_id", 5, $connection);
$order_id = pearclean($_GET, "order_id", 5, $connection);

$real_cust_id = getCust_id($_SESSION["loginUsername"]);

if ($cust_id != $real_cust_id)
{
   $_SESSION["message"] = "Moesz oglda tylko swoje potwierdzenia!";
   header("Location: " . S_HOME);
   exit;
}

// Wysanie do uytkownika poczty z potwierdzeniem.
send_confirmation_email($cust_id, $order_id, $connection);

// Przejcie do strony potwierdzenia (nie moe by to bieca strona,
// poniewa jej przeadowanie spowoduje wysanie kolejnej przesyki e-mail).
header("Location: " . S_ORDERRECEIPT . 
       "?cust_id={$cust_id}&order_id={$order_id}");
?>
