<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// This script validates customer data entered into details.php
// If validation succeeds, it INSERTs or UPDATEs
// a customer and redirects to a receipt page; if it 
// fails, it creates error messages and these are later 
// displayed by details.php

require_once "DB.php";
require_once "../includes/winestore.inc";
require_once "../includes/validate.inc";
require_once "../includes/authenticate.inc";

set_error_handler("customHandler");

session_start();

$connection = DB::connect($dsn, true);
if (DB::isError($connection))
   trigger_error($connection->getMessage(), E_USER_ERROR); 

// Kasowanie i rejestracja tablicy bdw - na wszelki wypadek!
$_SESSION["custErrors"] = array();

// Utworzenie tablicy custFormVars na zmienne POST.
$_SESSION["custFormVars"] = array();

// Wyszczyszczenie i adowanie zmiennych POST.
foreach($_POST as $varname => $value)
   $_SESSION["custFormVars"]["{$varname}"] = 
     pearclean($_POST, $varname, 50, $connection);

// Kontrola poprawnoci imienia.
checkMandatory("firstname", "first name", "custErrors", "custFormVars"); 

// Kontrola poprawnoci nazwiska.
checkMandatory("surname", "surname", "custErrors", "custFormVars");

// Kontrola poprawnoci adresu.
checkMandatory("address", "address", "custErrors", "custFormVars");

// Kontrola poprawnoci inicjau.
if (!empty($_SESSION["custFormVars"]["initial"]) && 
    !eregi("^[[:alpha:]]{1}$", $_SESSION["custFormVars"]["initial"]))
   $_SESSION["custErrors"]["initial"] = "Pole inicjau musi by puste lub " .
                                    "zawiera jeden znak.";

// Kontrola poprawnoci miasta.
checkMandatory("city", "city", "custErrors", "custFormVars");

// Kontrola poprawnoci kodu pocztowego.
if (checkMandatory("zipcode", "Zip code", "custErrors", "custFormVars"))
   checkZipcode("zipcode", "Zip code", "custErrors", "custFormVars");

// Telefon jest opcjonalny, ale jeeli jest wprowadzony, musi mie waciwy format.
if (!empty($_SESSION["custFormVars"]["phone"]))
   checkPhone("phone", "telephone", "custErrors", "custFormVars");

// Kontrola poprawnoci daty urodzenia
if (checkMandatory("birth_date", "date of birth", "custErrors", 
              "custFormVars"))
   checkDateAndAdult("birth_date", "date of birth", "custErrors", 
                "custFormVars");

// Kontrola poprawnoci adresu e-mail tylko jeeli jest to INSERT
if (!isset($_SESSION["loginUsername"]))
{  
   if (checkMandatory("loginUsername", "email/username", 
                 "custErrors", "custFormVars") &&
       emailCheck("loginUsername", "email/username", 
                  "custErrors", "custFormVars"))
   {
      // Sprawdzenie, czy adres jest uyty w aplikacji.
      $query = "SELECT * FROM users WHERE user_name = 
                '{$_SESSION["custFormVars"]["loginUsername"]}'";

      $result = $connection->query($query);
      if (DB::isError($result))
         trigger_error($result->getMessage(), E_USER_ERROR); 

      if ($result->numRows() == 1)
         $_SESSION["custErrors"]["loginUsername"] = 
            "Istnieje ju klient z tym adresem e-mail.";
   }

   // Kontrola poprawnoci - dugo od 6 do 8 znakw.
   if (checkMandatory("loginPassword", "password", 
                 "custErrors", "custFormVars"))
      checkMinAndMaxLength("loginPassword", 6, 8, "password", 
                      "custErrors", "custFormVars");
}

// Skrypt zakoczy kontrol poprawnoci, 
// teraz sprawdzenie, czy wystpiy bdy.
if (count($_SESSION["custErrors"]) > 0)
{
    // Wystpiy bdy, powrt do formularza klienta.
    header("Location: " . S_DETAILS);
    exit;
}

// Czy jest to aktualizacja?
if (isset($_SESSION["loginUsername"]))
{
   // Sprawd, czy uytkownik jest prawidowo zalogowany.
   sessionAuthenticate(S_DETAILS);   

   $cust_id = getCust_id($_SESSION["loginUsername"], $connection);

   $query = "UPDATE customer SET 
             title_id =    {$_SESSION["custFormVars"]["title_id"]},
             surname =     '{$_SESSION["custFormVars"]["surname"]}',
             firstname =   '{$_SESSION["custFormVars"]["firstname"]}',
             initial =     '{$_SESSION["custFormVars"]["initial"]}',
             address =     '{$_SESSION["custFormVars"]["address"]}',
             city =        '{$_SESSION["custFormVars"]["city"]}',
             state =       '{$_SESSION["custFormVars"]["state"]}',
             zipcode =     '{$_SESSION["custFormVars"]["zipcode"]}',
             country_id =  {$_SESSION["custFormVars"]["country_id"]},
             phone =       '{$_SESSION["custFormVars"]["phone"]}',
             birth_date =  '{$_SESSION["custFormVars"]["birth_date"]}'
             WHERE cust_id = {$cust_id}";

   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 
}
else
{
   // Zablokowanie tabeli w celu znalezienia nastpnej wartosci identyfikatora klienta.
   $result = $connection->query("LOCK TABLES customer WRITE");
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 

   // Szukanie maksymalnej wartoci cust_id.
   $result = $connection->query("SELECT max(cust_id) FROM customer");
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 

   $row = $result->fetchRow(DB_FETCHMODE_ASSOC);
   // Obliczenie nastpnej wartoci ID
   $cust_id = $row["max(cust_id)"] + 1;

   // Wstawienie danych nowego klienta.
   $query = "INSERT INTO customer VALUES ({$cust_id}, 
            '{$_SESSION["custFormVars"]["surname"]}', 
            '{$_SESSION["custFormVars"]["firstname"]}',  
            '{$_SESSION["custFormVars"]["initial"]}', 
            {$_SESSION["custFormVars"]["title_id"]}, 
            '{$_SESSION["custFormVars"]["address"]}', 
            '{$_SESSION["custFormVars"]["city"]}', 
            '{$_SESSION["custFormVars"]["state"]}', 
            '{$_SESSION["custFormVars"]["zipcode"]}', 
            {$_SESSION["custFormVars"]["country_id"]}, 
            '{$_SESSION["custFormVars"]["phone"]}', 
            '{$_SESSION["custFormVars"]["birth_date"]}')";

   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 

   // Odblokowanie tabeli customer.
   $result = $connection->query("UNLOCK TABLES");
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 

   // Poniewa by wykonywany INSERT, musimy rwnie wstawi dane do tabeli users.
   newUser($_SESSION["custFormVars"]["loginUsername"], 
           $_SESSION["custFormVars"]["loginPassword"], 
           $cust_id, $connection);

   // Zalogowanie uytkownika na nowe konto.
   registerLogin($_SESSION["custFormVars"]["loginUsername"]);
}

// Kasowanie custFormVars, dziki czemu formularz jest pusty.
unset($_SESSION["custFormVars"]);
unset($_SESSION["custErrors"]);

// Wywietlenie potwierdzenia utworzenia klienta.
header("Location: " . S_CUSTRECEIPT);
?>
