<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// This script shows the user a customer <form>.
// It can be used both for INSERTing a new customer and
// for UPDATE-ing an existing customer. If the customer 
// is logged in, then it is an UPDATE; otherwise, an INSERT.
// The script also shows error messages above widgets 
// that contain erroneous data: errors are generated 
// by validate.php

require_once "DB.php";
require_once "../includes/winestore.inc";
require_once "../includes/authenticate.inc";
require_once "../includes/template.inc";

set_error_handler("customHandler");

// Wywietlenie odpowiednich opisw dla operacji UPDATE lub INSERT
if (isset($_SESSION["loginUsername"]))
   $instructions = "Prosz zmieni pokazane poniej informacje o kliencie.";
else
   $instructions = "Prosz poda wymienione poniej dane.";

// Wymaga nagwka <form>, opisw, akcji, nazw formVars oraz formErrors
// jako parametrw.
$template = new winestoreFormTemplate("Informacje o kliencie", 
                $instructions, S_VALIDATE, "custFormVars", "custErrors");

session_start();

$connection = DB::connect($dsn, true);
if (DB::isError($connection))
  trigger_error($connection->getMessage(), E_USER_ERROR); 

// Czy uzytkonwik jest zalogowany i nie ma bdw z poprzedniej kontroli
// poprawnoci? Jeeli tak, wyszukaj klienta do modyfikacji.
if (isset($_SESSION["loginUsername"]) && 
    !isset($_SESSION["custErrors"]))
{
   // Sprawd, czy uytkownik jest poprawnie zalogowany.
   sessionAuthenticate(S_MAIN);

   $query = "SELECT title_id, surname, firstname, initial, address,
                    city, state, zipcode, country_id, phone, 
                    birth_date 
             FROM users, customer 
             WHERE users.cust_id = customer.cust_id 
             AND user_name = '{$_SESSION["loginUsername"]}'";

   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 

   $row = $result->fetchRow(DB_FETCHMODE_ASSOC);

   // Kasuj $_SESSION["custFormVars"], poniewa adujemy dane 
   // z tabeli customer.
   $_SESSION["custFormVars"] = array();

   // adowanie danych klienta do elementw formularza.
   foreach($row as $variable => $value)
      $_SESSION["custFormVars"]["{$variable}"] = $value;
}

// adowanie tytuw z tabeli title.
$titleResult = $connection->query("SELECT * FROM titles");
if (DB::isError($titleResult))
   trigger_error($titleResult->getMessage(), E_USER_ERROR); 

// adowanie krajw z tabeli country.
$countryResult = $connection->query("SELECT * FROM countries");
if (DB::isError($countryResult))
   trigger_error($countryResult->getMessage(), E_USER_ERROR); 

// Utworzenie elementw dla kadego z pl danych klienta.
$template->selectWidget("title_id", "Tytu:",
                        "title", $titleResult);
$template->mandatoryWidget("firstname", "Imi:", 50);
$template->mandatoryWidget("surname", "Nazwisko:", 50);
$template->optionalWidget("initial", "Inicja:", 1);
$template->mandatoryWidget("address", "Adres:", 50);
$template->mandatoryWidget("city", "Miasto:", 50);
$template->optionalWidget("state", "Stan:", 20);
$template->mandatoryWidget("zipcode", "kod pocztowy:", 10);
$template->selectWidget("country_id", "Kraj:",
                        "country", $countryResult);
$template->optionalWidget("phone", "Telefon:", 15);
$template->mandatoryWidget("birth_date", "Data urodzenia (dd/mm/yyyy):", 10);

// Dla nowych uytkownikw pokazanie tylko pl nazwa uytkownika i haso.
if (!isset($_SESSION["loginUsername"]))
{
   $template->mandatoryWidget("loginUsername", "E-mail/nazwa uytkownika:", 50);
   $template->passwordWidget("loginPassword", "Haso:", 15);
}

// Dodawanie przyciskw i komunikatw oraz wywietlenie strony.
$template->showWinestore(NO_CART, B_ALL & ~B_EMPTY_CART & ~B_UPDATE_CART & 
                ~B_PURCHASE & ~B_DETAILS & ~B_LOGINLOGOUT)
?>
