<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: David Lane and Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Skrypt kontrolujcy poprawno zmiany hasa uytkownika.

require_once "DB.php";
require_once "../includes/winestore.inc";
require_once "../includes/authenticate.inc";
require_once "../includes/validate.inc";

set_error_handler("customHandler");

session_start();

// Podczenie do autoryzowanej sesji.
sessionAuthenticate(S_MAIN);

$connection = DB::connect($dsn, true);

if (DB::isError($connection))
   trigger_error($connection->getMessage(), E_USER_ERROR); 

// Rejestrowanie i kasowanie tablicy bdw - na wszelki wypadek!
if (isset($_SESSION["pwdErrors"]))
   unset($_SESSION["pwdErrors"]);
$_SESSION["pwdErrors"] = array();

// Tworzenie tablicy formVars na zmienne POST.
$_SESSION["pwdFormVars"] = array();

foreach($_POST as $varname => $value)
   $_SESSION["pwdFormVars"]["{$varname}"] = 
     pearclean($_POST, $varname, 8, $connection);

// Kontrola hasa - pomidzy 6 i 8 znakw.
if (checkMandatory("currentPassword", "biece haso", 
              "pwdErrors", "pwdFormVars"))
  checkMinAndMaxLength("loginPassword", 6, 8, "biece haso", 
                  "pwdErrors", "pwdFormVars");

if (checkMandatory("newPassword1", "pierwsze nowe haso", 
              "pwdErrors", "pwdFormVars"))
  checkMinAndMaxLength("newPassword1", 6, 8, "pierwsze nowe haso", 
                  "pwdErrors", "pwdFormVars");

if (checkMandatory("newPassword2", "drugie nowe haso", 
              "pwdErrors", "pwdFormVars"))
  checkMinAndMaxLength("newPassword2", 6, 8, "drugie nowe haso", 
                  "pwdErrors", "pwdFormVars");

// Nie wystpiy bdy? Sprawdzmy, czy nowe hasa s takie same i inne 
// od biecego hasa.
// Nastpnie sprawdzamy biece haso.
if (count($_SESSION["pwdErrors"]) == 0)
{
   if ($_SESSION["pwdFormVars"]["newPassword1"] !=
       $_SESSION["pwdFormVars"]["newPassword2"])
     $_SESSION["pwdErrors"]["newPassword1"] = 
       "Nowe hasa musz by identyczne.";

   elseif ($_SESSION["pwdFormVars"]["newPassword1"] ==
           $_SESSION["pwdFormVars"]["currentPassword"])
     $_SESSION["pwdErrors"]["newPassword1"] =  
       "Haso musi by inne.";

   elseif (!authenticateUser($_SESSION["loginUsername"], 
                             $_SESSION["pwdFormVars"]["currentPassword"], 
                             $connection))
     $_SESSION["pwdErrors"]["currentPassword"] = 
       "Biece haso jest nieprawidowe.";
}

// Skrypt koczy kontrol
// sprawdzenie, czy wystpiy bdy.
if (count($_SESSION["pwdErrors"]) > 0)
{
    // Wystpiy bdy. Powrt do formularza hasa.
    header("Location: " . S_PASSWORD);
    exit;
}
                      
// Create the encrypted password
$stored_password = md5(trim($_SESSION["pwdFormVars"]["newPassword1"]));

// Update the user row
$query = "UPDATE users SET password = '$stored_password'
          WHERE user_name = '{$_SESSION["loginUsername"]}'";

$result = $connection->query($query);
if (DB::isError($result))
   trigger_error($result->getMessage(), E_USER_ERROR); 

// Kasowanie tablicy formVars wic formularz w przyszoci bdzie pusty.
unset($_SESSION["pwdFormVars"]);
unset($_SESSION["pwdErrors"]);

// Ustawienie komunikatu infromujcego o zmianie hasa.
$_SESSION["message"] = "Haso zostao zmienione.";

// Powrt na stron z danymi.
header("Location: " . S_DETAILS);
?>
