<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Skrypt pokazuje formularz pozwalajcy na zmian hasa.
// Uytkownik musi by zalogowany.

require_once "../includes/template.inc";
require_once "../includes/winestore.inc";
require_once "../includes/authenticate.inc";

set_error_handler("customHandler");

session_start();    

// Sprawdzenie, czy uytkownik jest prawidowo zalogowany.
sessionAuthenticate(S_MAIN);

// Jako parametrw potrzebuje nagwka formularza, instrukcji, akcji, nazwy tabeli formVars
// oraz formErrors
$template = new winestoreFormTemplate("Zmiana hasa", 
                "Prosz poda biece haso oraz dwukrotnie nowe haso.", 
                S_CHANGEPASSWORD, "pwdFormVars", "pwdErrors");

// Tworzenie elementw formularza zmiany hasa.
$template->passwordWidget("currentPassword", "Obecne haso:", 8);
$template->passwordWidget("newPassword1", "Nowe haso:", 8);
$template->passwordWidget("newPassword2", "Ponownie nowe haso:", 8);

// Dodanie przyciskw, komunikatw i pokazanie strony.
$template->showWinestore(NO_CART, B_HOME);
?>
