# Kod do tworzenia prostej tabeli dowcipów z identyfikatorem autora

CREATE TABLE joke (
	id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	joketext TEXT,
	jokedate DATE NOT NULL,
	authorid INT
) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

# Kod do tworzenia prostej tabeli autorów

CREATE TABLE author (
	id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	name VARCHAR(255),
	email VARCHAR(255)
) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

# Dodawanie autorów do bazy danych
# Podajemy identyfikatory, aby były one znane przy dodawaniu dowcipów w kolejnych poleceniach

INSERT INTO author SET
id = 1,
name = 'Kevin Yank',
email = 'thatguy@kevinyank.com';

INSERT INTO author (id, name, email)
VALUES (2, 'Jan Kowalski', 'jan@przyklad.com');

# Dodawanie dowcipów do bazy

INSERT INTO joke SET
joketext = 'Dlaczego kura przeszła przez szosę? Żeby dostać się na drugą stronę.',
jokedate = '2012-04-01',
authorid = 1;

INSERT INTO joke (joketext, jokedate, authorid)
VALUES (
'Ile zajmuje Windows 7? Ile znajdzie, tyle zajmie...',
'2012-04-01',
1
);

INSERT INTO joke (joketext, jokedate, authorid)
VALUES (
'Kupiłem synowi kamerę internetową. Jedną stronę pokoju ma teraz posprzątaną...',
'2012-04-01',
2
);
