CREATE TABLE author (
	id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	name VARCHAR(255),
	email VARCHAR(255),
	password CHAR(32),
	UNIQUE (email)
) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

CREATE TABLE joke (
	id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	joketext TEXT,
	jokedate DATE NOT NULL,
	authorid INT,
	FOREIGN KEY (authorid) REFERENCES author (id)
) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

CREATE TABLE category (
	id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	name VARCHAR(255)
) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

CREATE TABLE jokecategory (
	jokeid INT NOT NULL,
	categoryid INT NOT NULL,
	PRIMARY KEY (jokeid, categoryid),
	FOREIGN KEY (jokeid) REFERENCES joke (id),
	FOREIGN KEY (categoryid) REFERENCES category (id)
) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

CREATE TABLE role (
	id VARCHAR(255) NOT NULL PRIMARY KEY,
	description VARCHAR(255)
) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

CREATE TABLE authorrole (
	authorid INT NOT NULL,
	roleid VARCHAR(255) NOT NULL,
	PRIMARY KEY (authorid, roleid),
	FOREIGN KEY (authorid) REFERENCES author (id),
	FOREIGN KEY (roleid) REFERENCES role (id)
) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

# Przykładowe dane.
# Ustawiono identyfikatory, dzięki czemu są znane w momencie wstawiania powiązanych elementów

INSERT INTO author (id, name, email, password) VALUES
(1, 'Kevin Yank', 'thatguy@kevinyank.com', MD5('passwordijdb')),
(2, 'Joan Smith', 'joan@example.com', NULL);

INSERT INTO joke (id, joketext, jokedate, authorid) VALUES
(1, 'Dlaczego kura przeszła przez jezdnię? Aby się dostać na drugą stronę.', '2012-04-01', 1),
(2, '-Puk, puk. -Kto tam? -Satanista. -Nie wierzę. -Jak Boga kocham.', '2012-04-01', 1),
(3, 'Wchodzi facet do windy, a tam schody.', '2012-04-01', 1),
(4, 'Ilu prawników potrzeba, aby wkręcić żarówkę? Nie powiem - mogą mnie pozwać.', '2012-04-01', 2);

INSERT INTO category (id, name) VALUES
(1, 'Puk, puk'),
(2, 'O kurze'),
(3, 'Prawnicy'),
(4, 'Winda');

INSERT INTO jokecategory (jokeid, categoryid) VALUES
(1, 2),
(2, 1),
(3, 4),
(4, 3);

INSERT INTO role (id, description) VALUES
('Redaktor zawartości', 'Dodawanie, usuwanie i modyfikowanie żartów'),
('Administrator kont', 'Dodawanie, usuwanie i modyfikowanie autorów'),
('Administrator witryny', 'Dodawanie, usuwanie i modyfikowanie kategorii');

INSERT INTO authorrole (authorid, roleid) VALUES
(1, 'Administrator kont');
