<?php
define("LOGIN_OK", 1);
define("LOGIN_FAILED", 2);
define("SERVER_ERROR", 3);

define("ROWS_ON_PAGE", 5);

include 'admin/mydb.php';

class Portal
{
  private $dbo = null;
  private $news = null;
  function initDB($host, $user, $pass, $db)
  {
    $this->dbo = new MyDB($host, $user, $pass, $db);
    if($this->dbo->connect_errno){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $this->dbo->connect_error;
      throw new Exception($msg);
    }
  }
  function getUserInfo()
  {
    if(isset($_SESSION['zalogowany'])){
      $str = "Jesteś zalogowany jako: $_SESSION[zalogowany]. ";
      $str .= "<a href=\"logout.php\">Wylogowanie</a>";
    }
    else{
      $str = "Nie jesteś zalogowany.<br />";
      $str .= "<a href=\"index.php?action=showLoginForm\">Logowanie</a>";
    }
    return $str;
  }
  function getRegUsersOnline($timeout)
  {
    if(!$this->dbo) return false;
    
    $query = "SELECT COUNT(*) FROM Stats WHERE Data > ";
    $query .= "DATE_SUB(NOW(), INTERVAL $timeout MINUTE) ";
    $query .= "AND UserId <> 0";

    return $this->dbo->getQuerySingleResult($query);
  }
  function getAllUsersOnline($timeout)
  {
    if(!$this->dbo) return false;
  
    $query = "SELECT COUNT(*) FROM Stats WHERE DATA > ";
    $query .= "DATE_SUB(NOW(), INTERVAL $timeout MINUTE)";
    
    return $this->dbo->getQuerySingleResult($query);
  }
  function getShortStats($timeout)
  {
    $regUsers = $this->getRegUsersOnline($timeout);
    $allUsers = $this->getAllUsersOnline($timeout);
    if($regUsers === false || $allUsers === false){
      return "Statystyki nie są dostępne.";
    }
    else{
      $msg = "W ciągu ostatnich $timeout minut stronę odwiedziło ";
      $msg .= "$allUsers gości, w tym $regUsers zarejestrowanych ";
      $msg .= "użytkowników. ";
      return $msg;
    }
  }
  function getFullStats()
  {
    if(!$this->dbo) return "Statystki nie są dostępne.";
  
    //Weryfikacja danych
    $ile = -1;
    if(isset($_GET['ile'])){
      $ile = intval($_GET['ile']);
      if($ile >= -1){
        if($ile == 0){
          //Czy zostały przekazane daty?
          if(isset($_GET['dataOd']) && isset($_GET['dataDo'])){
            //Czy daty odpowiadają formatowi?
            if(!preg_match("/^[0-9]{8}$/", $_GET['dataOd']) ||
               !preg_match("/^[0-9]{8}$/", $_GET['dataDo'])){
              //Niezgodność formatu.
              $ile = -1;
            }
            else{
              //Odczytanie dat.
              $dataOd = $_GET['dataOd'];
              $dataDo = $_GET['dataDo'];
            }
          }
          //Brak dat przy zaznaczonej opcji zakresu.
          else{
            $ile = -1;
          }
        }
        else{
          //Ustalenie maksymalnej dopuszczzalnej liczby dni.
          if($ile > 3660) $ile = 3660;
        }
      }
      //Parametr ile był nieprawidłowy.
      else{
       $ile = -1;
      } 
    }
    
    //Formowanie warunków zapytań i nagłówka tabeli.
    if($ile == 0){
      //Dodanie warunku dotyczącego dat.
      $cond = " WHERE Data >= '$dataOd' AND Data <= '$dataDo' ";
      $statsInfo = "Statystyki z okresu $dataOd do $dataDo.";
    }
    else if($ile > 0){
      //Dodanie warunku dotyczącego wybranego okresu.
      $cond = " WHERE Data > DATE_SUB(NOW(), INTERVAL $ile DAY) ";
      $statsInfo = "Statystyki z ostatnich $ile dni.";
    }
    else{
      //Dodanie pustego warunku.
      $cond = ' WHERE 1=1 ';
      $statsInfo = "Pełne statystyki";
    }
    
    //Pobieranie liczby odwiedzin.
    $query = "SELECT COUNT(*) AS Ile FROM Stats ";
    $allVisits = $this->dbo->getQuerySingleResult(
      $query . $cond );
    $regVisits = $this->dbo->getQuerySingleResult(
      $query . $cond . 'AND UserId <> 0 ');
    $allVisits = intval($allVisits);
    $regVisits = intval($regVisits);
    $guestVisits = $allVisits - $regVisits;
    
    //Pobieranie statystyk przeglądarek.
    $query = "SELECT Nazwa, COUNT(*) AS Ile FROM Stats, Przegladarki ";
    $query .= $cond;
    $query .= " AND Stats.BrowserId = Przegladarki.Id ";
    $query .= "GROUP BY BrowserId";
    
    $browsersInfo = $this->dbo->getQueryResultAsTableRows($query);

    //Pobieranie statystyk systemów.
    $query = "SELECT Nazwa, COUNT(*) AS Ile FROM Stats, Systemy ";
    $query .= $cond;
    $query .= " AND Stats.SystemId = Systemy.Id ";
    $query .= "GROUP BY SystemId";

    $systemsInfo = $this->dbo->getQueryResultAsTableRows($query);
    
    //Najczęściej logujący się użytkownicy.
    $query = "SELECT Nazwa, COUNT(*) AS Ile FROM Stats, Users ";
    $query .= $cond;
    $query .= " AND Stats.UserId = Users.Id AND Users.Id <> 0 ";
    $query .= "GROUP BY UserId LIMIT 10";

    $activeUsers = $this->dbo->getQueryResultAsTableRows($query);
    
    //Najczęściej występujące adresy IP.
    $query = "SELECT IP, COUNT(*) AS Ile FROM Stats ";
    $query .= $cond;
    $query .= "GROUP BY Ip LIMIT 10";
    
    $ips = $this->dbo->getQueryResultAsTableRows($query);
    
    //Adresy IP i daty ostatnich 10 połączeń.
    $query = "SELECT IP, Data FROM Stats ";
    $query .= $cond;
    $query .= "ORDER BY Data DESC LIMIT 10";
    
    $lastips = $this->dbo->getQueryResultAsTableRows($query);
    
    include 'statTable.php';
    return $result;
  }

  function login()
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["haslo"])){
      return LOGIN_FAILED;
    }
    
    $user = $_POST["user"];
    $pass = $_POST["haslo"];
    
    //Sprawdzenie długości przekazanych ciągów.
    //Dla kodowania jednobajtowego
    //$userNameLength = strlen($user);
    //$userPassLength = strlen($pass);
    //Dla kodowania utf-8
    $userNameLength = strlen(utf8_decode($user));
    $userPassLength = strlen(utf8_decode($pass));
    
    if($userNameLength < 3 || $userNameLength > 20 ||
     $userPassLength < 6 || $userPassLength > 40){
      return LOGIN_FAILED;
    }
  
    //Zabezpieczenie znaków specjalnych w parametrach.
    $user = $this->dbo->real_escape_string($user);
    $pass = $this->dbo->real_escape_string($pass);
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query = "SELECT Haslo, Nazwa, Id ";
    $query .= "FROM Users WHERE Nazwa='$user'";

    if(!$result = $this->dbo->query($query)){
      //echo 'Wystąpił błąd: nieprawidłowe zapytanie...';
      return SERVER_ERROR;
    }

    //Sprawdzenie wyników zapytania.
    if($result->num_rows <> 1){
      //Brak użytkownika o wskazanej nazwie lub zbyt wiele wyników.
      return LOGIN_FAILED;
    }
    else{
      $row = $result->fetch_row();
      $pass_db = $row[0];
      //Wersja bez kodowania haseł.
      //if($pass != $pass_db){
      //Wersja z kodowaniem haseł.
      if(crypt($pass, $pass_db) != $pass_db){
        return LOGIN_FAILED;
      }
      else{
        $_SESSION['zalogowany'] = $row[1];
        $_SESSION['userId'] = $row[2];
        if(isset($_SESSION['statRecordId']) && 
                ($_SESSION['statRecordId'] > 0)){
          $this->updateStatRecord($_SESSION['statRecordId'], $row[2]);
        }
        else{
          $_SESSION['statRecordId'] = $this->addStatRecord($row[2]);
        }
        return LOGIN_OK;
      }
    }
  }
  function logout()
  {
    if(isset($_SESSION['zalogowany'])){
      unset($_SESSION['zalogowany']);
      unset($_SESSION['userId']);
      $_SESSION['statRecordId'] = -1;
      /*
      //Jeśli sesja ma być usunięta:
      unset($_SESSION['statRecordId']);
      if (isset($_COOKIE[session_name()])){
        setcookie(session_name(), '', time() - 3600);
      }
      session_destroy();
      */
    }
  }
  
  function addStatRecord($userId)
  {
    if(!$this->dbo) return 0;
    
    $browser = get_browser();
  
    //Pobranie identyfikatora przeglądarki (jeśli istnieje).
    $browserName = $this->dbo->real_escape_string($browser->browser);
    $query = "SELECT id FROM Przegladarki WHERE Nazwa='$browserName'";
    
    if(($browserId = $this->dbo->getQuerySingleResult($query)) === false){
      //Jezeli nie ma przeglądarki w bazie, dodanie nowego wpisu.
      $query = "INSERT INTO Przegladarki VALUES(NULL,'$browserName')";
      if(!$result = $this->dbo->query($query)){
        return 0;
      }
      //Pobranie identyfikatora nowego wpisu.
      $browserId = $this->dbo->insert_id;
    }
    
    //Pobranie identyfikatora systemu (jeśli istnieje).
    $systemName = $this->dbo->real_escape_string($browser->platform);
    $query = "SELECT id FROM Systemy WHERE Nazwa = '$systemName'";
    
    if(($systemId = $this->dbo->getQuerySingleResult($query)) === false){
      //Jezeli nie ma systemu w bazie, dodanie nowego wpisu.
      $query = "INSERT INTO Systemy VALUES(NULL, '$systemName')";
      if(!$result = $this->dbo->query($query)){
        return 0;
      }
      //Pobranie identyfikatora nowego wpisu.
      $systemId = $this->dbo->insert_id;
    }
    
    if(!$systemId || !$browserId) return 0;
        
    //Dodanie nowego wpisu do tabeli Stats.
    $ip = $_SERVER['REMOTE_ADDR'];
    $query = "INSERT INTO STATS VALUES(";
    $query .= "NULL, '$ip', NOW(), $systemId, $browserId, $userId)";

    //Jeżeli wystąpił błąd przy dodawaniu wpisu dotyczącego przeglądarki lub systemu.
    if(!$this->dbo->query($query)){
      //echo 'Rekord statystyk nie został dodany.';
      return 0;
    }
    //Zwrócenie identyfikatora nowego wpisu.
    return $this->dbo->insert_id;
  }
  function updateStatRecord($recordId, $userId)
  {
    if(!$this->dbo) return;
    
    $query = "UPDATE Stats SET UserId = $userId WHERE Id = $recordId";
    if(!$this->dbo->query($query)){
      //echo 'Nie udała się aktualizaja statystyk.';
    }
  }
  function getNewsHeaders($ile)
  {
    if(!$this->dbo) return 'Błąd serwera. Brak nagłówków news.';
    $query = 'SELECT Id, Naglowek FROM News ORDER BY Data LIMIT '.$ile;
    if(!$result = $this->dbo->query($query)){
      return 'Błąd serwera. Brak nagłówków news.';
    }
    $str = '';
    while($row = $result->fetch_row()){
      $str .= '<div class="newsHeaderDiv">'.$row[1];
      $str .= ' <a href="index.php?action=showNews&amp;newsId=';
      $str .= $row[0].'">Więcej</a></div>';
    }
    return $str;
  }
  function getNews()
  {
    if(!$this->dbo)
      return 'Błąd serwera. Nie można wyświetlić wiadomości.';
    
    //Pobranie identyfikatora news.
    if(!isset($_GET['newsId'])){
      return 'Brak identyfikatora news.';
    }
    else{
      $newsId = intval($_GET['newsId']);
    }
    
    //Formowanie zapytania.
    $query = "SELECT n.Naglowek, n.Tresc, n.Data, u.Nazwa ";
    $query .= "FROM News n INNER JOIN Users u ";
    $query .= "ON n.UserId = u.id ";
    $query .= "WHERE n.id = $newsId";
    
    if(!$result = $this->dbo->query($query)){
      return 'Błąd serwera. Brak newsa.';
    }
    
    //Pobieranie wyników.
    $str = '<div id="newsDiv">';
    if($row = $result->fetch_row()){
      $str .= '<table><tr>';
      $str .= '<td>Nagłówek</td><td>'.$row[0].'</td></tr>';
      $str .= '<tr><td>Data</td><td>'.$row[2].'</td></tr>';
      $str .= '<tr><td>Autor</td><td>'.$row[3].'</td></tr>';
      $str .= '<tr><td>Treść</td><td>'.$row[1].'</td></tr>';
      $str .= '</tr></table>';
    }
    else{
      echo 'Brak newsa o podanym id.';
    }
    $str .= '</div>';
    
    return $str;
  }
  function getNewsList($limit)
  {
    if(!$this->dbo){
      return 'Lista newsów nie jest dostępna.';
    }
    
    //Odczytanie parametru page.
    if(isset($_GET['page'])){
      $page = intval($_GET['page']);
    }
    else{
      $page = 0;
    }
    
    //Określenie całkowitej liczby wierszy w tabeli News.
    $query = "SELECT COUNT(*) FROM News";
    $rowsCount = intval($this->dbo->getQuerySingleResult($query));
    
    //Obliczenie całkowitej liczby stron z wynikami.
    if($limit != 0){
      $pages = ceil($rowsCount / $limit);
      if($page < 0 || $page >= $pages){
        $page = 0;
      }
      $offset = $page * $limit;
    }
    else{
      $page = 0;
      $pages = 1;
      $offset = 0;
      $limit = $rowsCount;
    }
    
    //Zapytanie pobierające wyniki dla bieżącej strony.
    $query = "SELECT n.Id, n.Naglowek, n.Data, u.Nazwa ";
    $query .= "FROM News n INNER JOIN Users u ";
    $query .= "ON n.UserId = u.Id ";
    $query .= "ORDER BY Data DESC ";
    $query .= "LIMIT $offset, $limit";
    
    if(!$result = $this->dbo->query($query)){
      echo 'Błąd serwera. Brak listy news.';
    }
    
    //Formowanie wyników.
    $str = '<div id="newsListDiv">';
    $str .= '<table><tr>';
    $str .= '<th>Nagłówek</th><th>Data</th><th>Autor</th>';
    $str .= '</tr>';

    //Odczyt wyników zapytania.
    while($row = $result->fetch_row()){
      $str .= '<tr>';
      $str .=  '<td><a href="index.php?action=showNews&amp;newsId='.
         $row[0].'">'.$row[1].'</a></td>';
      $str .= '<td>'.$row[2].'</td>';
      $str .= '<td>'.$row[3].'</td>';
      $str .= '</tr>';
    }
    $str .= '</table>';
    
    //Uzyskanie paginacji.
    $str .= '<div id="paginationDiv">';
    $str .= $this->dbo->getPagination($page, $pages, 
                      'index.php?action=showNewsList',
                      'Idź do strony: ');
    $str .= '</div></div>';
    
    return $str;
  }
  function getSubscriptions()
  {
    if(!$this->dbo){
      return 'Lista subskrypcji nie jest dostępna.';
    }
    
    //Sprawdzenie czy użytkownik jest zalogowany.
    if(!isset($_SESSION['zalogowany'])){
      return 'Lista subskrypcji jest dostępna tylko dla zalogwanych użytkowników.';
    }
    
    $userId = $_SESSION['userId'];
    
    //Formowanie zapytania pobierającego listę subskrypcji.
    $query = "SELECT Id, Nazwa, UserId ";
    $query .= "FROM Subskrypcje s LEFT JOIN Uzytkownicy_Subskrypcje su ";
    $query .= "ON su.SubskrypcjaId = s.Id ";
    $query .= "AND su.UserId = $userId";
    
    if(!$result = $this->dbo->query($query)){
      return 'Błąd serwera. Brak listy subskrypcji.';
    }
    
    //Formularz, warstwa i początek tabeli HTML.
    $str = '';
    $str .= '<form action = "index.php" method = "get">';
    $str .= '<div id="subscriptionsDiv">';
    $str .= '<input type="hidden" name="action" value="saveSubscriptions" />';
    $str .= '<table>';
    
    //Pobranie wyników zapytania.
    while($row = $result->fetch_row()){
      $checked = ($row[2] == '')?'':'checked="checked"';
      $str .= '<tr><td>';
      $str .= '<input type="checkbox" name="'.$row[0].'" '.$checked.' />';
      $str .= '</td><td>'.$row[1].'</td></tr>';
    }
    $str .= '<tr><td colspan="2">';
    $str .= '<input type="submit" value="Zapisz"></td></tr>';
    $str .= '</table></div></form>';
    
    return $str;
  }
  function saveSubscriptions()
  {
    if(!$this->dbo){
      return 'Błąd serwera. Dane nie zostały zapisane.';
    }
    
    //Pobranie wszystkich wierszy z tabeli Subskrypcje.
    $query = "SELECT Id FROM Subskrypcje";
    
    if(!$result = $this->dbo->query($query)){
      return 'Błąd serwera. Dane nie zostały zapisane.';
    }
    
    //Wykonanie zapytań modyfikujących i usuwających rekordy.
    while($row = $result->fetch_row()){
      if(isset($_GET[$row[0]])){
        $query = 'REPLACE INTO Uzytkownicy_Subskrypcje VALUES(';
        $query .= $_SESSION['userId'].', '.$row[0].')';
      }
      else{
        $query = 'DELETE FROM Uzytkownicy_Subskrypcje WHERE ';
        $query .= 'UserId = '.$_SESSION['userId'].' AND SubskrypcjaId = ';
        $query .= $row[0];
      }
      $this->dbo->query($query);
    }
    return 'Dane zostały zapisane.';
  }
}
?>