<?php
define("LOGIN_OK", 1);
define("LOGIN_FAILED", 2);
define("SERVER_ERROR", 3);
define("NO_ADMIN_RIGHTS", 4);

define("ACTION_OK", 101);
define("ACTION_FAILED", 102);

define("FORM_DATA_MISSING", 103);
define("INVALID_USER_NAME", 104);
define("INVALID_USER_ID", 105);
define("INVALID_PASS", 106);
define("INVALID_EMAIL", 107);
define("USER_NOT_FOUND", 108);
define("USER_NAME_ALREADY_EXISTS", 109);
define("USER_ID_ALREADY_EXISTS", 110);

define("ROWS_ON_PAGE", 5);

include 'users_admin.php';

class PortalAdmin
{
  private $dbo = null;
  function initDB($host, $user, $pass, $db)
  {
    $this->dbo = new mysqli($host, $user, $pass, $db);
    if($this->dbo->connect_errno){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $this->dbo->connect_error;
      throw new Exception($msg);
    }
  }

  function login()
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["haslo"])){
      return LOGIN_FAILED;
    }
    
    $user = $_POST["user"];
    $pass = $_POST["haslo"];
    
    //Sprawdzenie długości przekazanych ciągów.
    //Dla kodowania jednobajtowego
    //$userNameLength = strlen($user);
    //$userPassLength = strlen($pass);
    //Dla kodowania utf-8
    $userNameLength = strlen(utf8_decode($user));
    $userPassLength = strlen(utf8_decode($pass));
    
    if($userNameLength < 3 || $userNameLength > 20 ||
       $userPassLength < 6 || $userPassLength > 40){
      return LOGIN_FAILED;
    }
  
    //Zabezpieczenie znaków specjalnych w parametrach.
    $user = $this->dbo->real_escape_string($user);
    $pass = $this->dbo->real_escape_string($pass);
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query = "SELECT Haslo, Nazwa, Id ";
    $query .= "FROM Users WHERE Nazwa='$user'";

    if(!$result = $this->dbo->query($query)){
      //echo 'Wystąpił błąd: nieprawidłowe zapytanie...';
      return SERVER_ERROR;
    }

    //Sprawdzenie wyników zapytania.
    if($result->num_rows != 1){
      //Brak użytkownika o wskazanej nazwie lub zbyt wiele wyników.
      return LOGIN_FAILED;
    }
    else{
      $row = $result->fetch_row();
      $pass_db = $row[0];
      //Wersja bez kodowania haseł.
      //if($pass != $pass_db){
      //Wersja z kodowaniem haseł.
      if(crypt($pass, $pass_db) != $pass_db){
        return LOGIN_FAILED;
      }
      else{
        $_SESSION['zalogowany_adm'] = $row[1];
      }
      
      //Obsługa przywilejów.
      
      //Utworzenie zmiennej sesji, jeśli konieczne.
      if(!isset($_SESSION['przywileje'])){
        $_SESSION['przywileje'] = array();
      }
      
      //Zapytanie pobierające dane.
      $query = "SELECT PrzywilejId FROM Uzytkownicy_Przywileje ";
      $query .= "WHERE UserId=" . $row[2];
      
      //Zapis danych o przywilejach z zmiennej sesji.
      if($result = $this->dbo->query($query)){
         while($row = $result->fetch_row()){
           $_SESSION['przywileje'][$row[0]] = true;
         }
      }
      
      //Rezultat logowania.
      if(isset($_SESSION['przywileje'][1])){
        return LOGIN_OK;
      }
      else{
        return NO_ADMIN_RIGHTS;
      }
    }
  }
  function logout()
  {
    if(isset($_SESSION['zalogowany_adm'])){
      unset($_SESSION['zalogowany_adm']);
      unset($_SESSION['przywileje']);
      unset($_SESSION['komunikat_adm']);
      if (isset($_COOKIE[session_name()])){
        setcookie(session_name(), '', time() - 3600);
      }
      session_destroy();
    }
  }
  function usersAdmin()
  {
    $ua = new UsersAdmin($this->dbo);
    if(isset($_GET['wtd'])){
      $wtd = $_GET['wtd'];
    }
    else{
      $wtd = 'showList';
    }
    switch($wtd){
      case 'showEditForm':
        $ua->showEditForm('edit');
        break;
      case 'showAddForm':
        $ua->showEditForm('add');
        break;
      case 'showSearchForm':
        $ua->showSearchForm();
        break;
      case 'addUser' :
        switch($ua->editUser('add')){
          case ACTION_OK :
            echo 'Użytkownik został dodany.';
            break;
          case INVALID_USER_ID:
            echo 'Nieprawidłowy identyfikator użytkownika.';
            break;
          case INVALID_USER_NAME:
            echo 'Nieprawidłowa nazwa użytkownika.';
            break;
          case USER_NAME_ALREADY_EXISTS:
            echo 'Użytkownik o podanej nazwie istnieje w bazie.';
            break;
          case USER_ID_ALREADY_EXISTS:
            echo 'Użytkownik o podanym id istnieje w bazie.';
            break;
          case SERVER_ERROR :
          default:
            echo 'Błąd serwera. Użytkownik nie został dodany.';
        }
        break;
      case 'modifyUser' :
        switch($ua->editUser('edit')){
          case ACTION_OK :
            echo 'Dane zostały zmienione.';
            break;
          case INVALID_USER_ID:
            echo 'Nieprawidłowy identyfikator użytkownika.';
            break;
          case INVALID_USER_NAME:
            echo 'Nieprawidłowa nazwa użytkownika.';
            break;
          case FORM_DATA_MISSING:
            echo 'Brak danych z formularza.';
            break;
          case SERVER_ERROR :
          default:
            echo 'Błąd serwera. Danie nie zostały zmienione.';
        }
        break;
      case 'searchUser' :
        $ua->showSearchForm();
        switch ($ua->searchUser()){
          case ACTION_OK:
            break;
          case USER_NOT_FOUND:
            echo 'Nie znaleziono użytkownika.';
            break;
          case FORM_DATA_MISSING :
            echo 'Brak danych z formularza.';
            break;
          case INVALID_USER_ID :
            echo 'Błędny identyfikator użytkownika.';
            break;
          case INVALID_USER_NAME :
            echo 'Błędna nazwa użytkownika.';
            break;
          case SERVER_ERROR:
          default:
            echo 'Błąd serwera.';
        }
        break;
      case 'deleteUser':
        switch($ua->deleteUser()){
          case ACTION_OK:
            echo 'Użytkownik został usunięty.';
            break;
          case USER_NOT_FOUND:
            echo 'Brak użytkownika o podanym id.';
            break;
          case INVALID_USER_ID:
            echo 'Nieprawidłowy identyfikator użytkownika.';
            break;
          case SERVER_ERROR:
          default:
           echo 'Błąd serwera.';
        }
        break;
      case 'showList' :
      default:
        $ua->showList(ROWS_ON_PAGE);
    }
  }
}
?>