"use strict";

(function($){

    // Wtyczka powiększająca tekst po umieszczeniu kursora nad elementem
    // i przywracająca jego oryginalny rozmiar, gdy kursor znajdzie się poza elementem
    $.fn.dateZoom = function(options)
    {
        // Nadpisz tylko te wartości, które zostały przekazane przez
        // użytkownika w argumencie options
        var opts = $.extend($.fn.dateZoom.defaults, options);

        // Zmodyfikuj w pętli wybrane elementy i zwróć
        // obiekt jQuery, aby umożliwić łączenie wywołań
        return this.each(function(){
            // Zapisz pierwotny rozmiar czcionki elementu
            var originalsize = $(opts.selector).css("font-size");

            // Dołącz procedury obsługi zdarzenia hover. Pierwsza będzie
            // wywołana, gdy użytkownik umieści kursor myszy nad elementem, a
            // druga, gdy usunie go znad elementu.
            $(opts.selector).hover(function(){
                    $.fn.dateZoom.zoom(opts.selector, opts.fontsize, opts);
                },
                function(){
                    $.fn.dateZoom.zoom(opts.selector, originalsize, opts);
                });
        });
    };

    // Definiuj domyślne wartości dla wtyczki
    $.fn.dateZoom.defaults = {
            "fontsize" : "110%",
            "easing" : "swing",
            "duration" : "600",
            "selector" : "li>a",
            "match" : "href",
            "callback" : null
        };

    // Definiuj funkcję narzędziową, którą można wywołać
    // również poza wtyczką
    $.fn.dateZoom.zoom = function(element, size, opts)
    {

        // Ogranicz efekt powiększenia do elementu, nad którym znajduje się kursor.
        if (opts.match)
        {
            element = $.grep($(element), function(elem) {
                return elem[opts.match] === $('a:hover')[0][opts.match];
            });
        }

        $(element).animate({
                    "font-size" : size
                },{
                    "duration" : opts.duration,
                    "easing" : opts.easing,
                    "complete" : opts.callback
                })
            .dequeue() // Zapewnij płynność animacji
            .clearQueue(); // Upewnij się, że w kolejce nie ma innych animacji
    };
})(jQuery);
