<?php

declare(strict_types=1);

/*
 * Załaduj niezbędne ustawienia konfiguracyjne
 */
include_once '../sys/config/db-cred.inc.php';

/*
 * Zdefiniuj stałe konfiguracyjne
 */
foreach ( $C as $name => $val )
{
    define($name, $val);
}

/*
 * Utwórz obiekt PDO
 */
$dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME;
$dbo = new PDO($dsn, DB_USER, DB_PASS);
$dbo->query("SET NAMES 'utf8'");

/*
 * Mechanizm automatycznego ładowania klas
 */
function __autoload($class)
{
    $filename = "../sys/class/class." . $class . ".inc.php";
    if ( file_exists($filename) )
    {
        include_once $filename;
    }
}

?>