<?php
declare(strict_types = 1); // dbamy o prawidłowe typy danych

function rejestracja_pojazdu(?string $numer = '') : string|bool 
{
    // deklaracja tabeli z prefiksami i nazwami województw
    $rej = [
        "B" => "podlaskie",
        "C" => "kujawsko-pomorskie",
        "D" => "dolnośląskie",
        "E" => "łódzkie",
        "F" => "lubuskie",
        "G" => "pomorskie",
        "K" => "małopolskie",
        "L" => "lubelskie",
        "N" => "warmińsko-mazurskie",
        "O" => "opolskie",
        "P" => "wielkopolskie",
        "R" => "podkarpackie",
        "S" => "śląskie",
        "T" => "świętokrzyskie",
        "W" => "mazowieckie",
        "Z" => "zachodniopomorskie"
    ];

    // pobranie pierwszego znaku z numeru i zamiana na wielką literę
    $prefiks = mb_strtoupper(mb_substr($numer, 0, 1)); 

    // zwróć nazwę województwa, jeśli prefiks istnieje w tabeli
    return isset($rej[$prefiks]) ? (string)$rej[$prefiks] : (bool)false;
}

function triangle(float $a, float $h) : float // funkcja licząca pole trójkąta
{
    $p = (0.5 * $a * $h); // obliczanie pola
    return (float)$p; // zwracanie wyniku
}