<?php
$_GET['tytul'] = " WieŻa#"; // szukana fraza

$proces = [];

/* pierwsza optymalizacja danych */
$szukaj = (string)$_GET['tytul']; // rzutujemy do typu string
$proces[] = $szukaj;

// obcinamy boczne spacje i zamieniamy na małe litery
$szukaj = trim(mb_strtolower($szukaj));
$proces[] = $szukaj;

// wycinamy wszystko, co nie jest cyfrą, literą, podkreśleniem itp.
$szukaj = preg_replace('/[^0-9 a-z-!_\\p{L}]/u', '', $szukaj);
$proces[] = $szukaj;

if ($szukaj == '') {
    die("Nie ma co szukać ;(");
}

try {
    $db_file = 'kartoteka.db';

    // otwórz połączenie z bazą SQLite lub utwórz nowy plik dla bazy
    $db_pdo = new PDO('sqlite:'.__DIR__.'/'.$db_file);
    
    // włącz obsługę wyjątków dla obsługi interfejsu PDO
    $db_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    /* przygotowanie zapytania SQL */
    $stmt = $db_pdo->prepare("SELECT * FROM ksiazki WHERE tytul LIKE :tytul");
    
    $szukaj = '%'.$szukaj.'%'; // znaki specjalne dla operatora LIKE

    // sprawdź, czy przekazany parametr jest tekstem
    if ($stmt->bindValue(':tytul', $szukaj, PDO::PARAM_STR))
    {
        /* wykonaj przygotowane zapytanie SQL */
        $stmt->execute();
        print_r($stmt->fetch(PDO::FETCH_ASSOC));

        print "Co się działo ze zmienną 'szukaj' w trakcie działania programu?";
        print PHP_EOL.str_repeat('-', 63).PHP_EOL;
        foreach ($proces as $p) {
            print $p." => ";
        }

        print $szukaj;
    }

    $db_pdo = NULL; // zamknij połączenie z bazą

} catch (PDOException $e) {
    print "Błąd!: " . $e->getMessage();
    die();
}