case class CommandLineOption(description : String, func : () => Unit)

object CommandLine {

  val options : Map[String, CommandLineOption] = Map(
    "1" -> new CommandLineOption("Dodaj klienta", Customer.createCustomer),
    "2" -> new CommandLineOption("Wyświetl klientów", Customer.list),
    "3" -> new CommandLineOption("Wyświetl aktywne kontakty dla aktywnych klientów", 
      () => Customer.eachEnabledContact(contact => println(contact))
    ),
    "q" -> new CommandLineOption("Wyjdź", sys.exit)
  )

  def askForInput(question : String) : String = {
  	print(question + ": ")
  	readLine()
  }

  def prompt() = {
    options.foreach(option => println(option._1 + ") " + option._2.description))
    options.get(askForInput("Opcja").trim.toLowerCase) match {
      case Some(CommandLineOption(_, exec)) => exec()
      case _ => println("Nieprawidłowe dane wejściowe")
    }
  }

  def main(args : Array[String]) = {
  	Customer.allCustomers = List()
  	while(true) {
      prompt()
  	}
  }
}