#!perl

use strict;
use warnings;

use Test::More tests => 5;
use Test::Exception;

use File::Spec::Functions;

ok( require( 'filefilter.pl' ), 'udao si wczytanie pliku' ) or exit;

throws_ok { main() } qr/Uycie:/, 'main() powinno wywietli bd uycia bez adnych argumentw';

throws_ok { main( 'ze polecenie' ) } qr/Nieznane polecenie 'ze polecenie'/, '... albo informacj o nieprawidowym poleceniu';

my @directories =
(
   'historia_muzyki',
   map { catdir( 'historia_muzyki', $_ ) } qw( handel vivaldi telemann )
);

my @files = map { catfile( 'historia_muzyki', $_ ) } qw( barok klasycyzm );

is_deeply( [ cmd_dirs( @directories, @files ) ], \@directories, 'polecenie powinno zwrci tylko katalogi' );

is( cmd_latest( @files ), catfile(qw( historia_muzyki klasycyzm )), 'ostatnie polecenie powinno zwrci ostatnio zmodyfikowany plik' );
