#!perl

use strict;
use warnings;

use IPC::Run 'run';
use Test::More tests => 7;

my ($out, $err) = runperl( '-v' );
like($out, qr/This is perl/, '-v powinno wypisa krtk informacj o wersji');     
is(  $err, '',               '... i nie zgasza bdw'                    );

($out, $err)    = runperl( '-V' ) ;
like($out, qr/Compiled at/,  '-V powinno wypisa rozszerzon informacj o wersji');
is(  $err, '',               '... i nie zgasza bdw'                         );

($out, $err)    = runperl(qw( -e x++ ));
like($err, qr/Can't modify constant.+postincrement/, 'modyfikacja staej powinna zgosi bd i zakoczy si' );
like( $err, qr/Execution.+aborted.+compilation errors/, '... przerywajc wykonanie z powodu bdw kompilacji'  );
is( $out, '', '... nic nie piszc na standardowe wyjcie' ); 

sub runperl
{
   run( [ $^X, @_ ], \my( $in, $out, $err ) );
   return ($out, $err);
}
