#!perl

use strict;
use warnings;

use Test::More tests => 6;

my @subs = qw( words count_words );

BEGIN { use_ok( 'AnalyzeSentence', @subs, '$WORD_SEPARATOR'  ) or exit;}
can_ok(__PACKAGE__, 'AnalyzeSentence::words'       );
can_ok(__PACKAGE__, 'AnalyzeSentence::count_words' );

my $sentence = 
      'Krlowa Ester, wadczyni przymierza ludzi i ab, na swoj cze 
       ochoczo poera monumentalny deser lodowy.';

my @words = AnalyzeSentence::words( $sentence );
ok( @words == 15, 'words() powinno zwraca wszystkie sowa w zdaniu' );


$sentence = 'Szalejce idee zachannie dr.';
my $count = AnalyzeSentence::count_words( $sentence );

ok( $count == 4, 'count_words() powinno obsuy proste zdania');

$WORD_SEPARATOR = qr/(?:\s|-)+/;
@words = AnalyzeSentence::words( $sentence );
ok( @words == 4, '... dotyczy $WORD_SEPARATOR, jeli tylko ustawione' );

   