#!perl

use strict;
use warnings;

use lib 'lib';

use Test::More tests => 11;
use Test::Exception;

my $module = 'SongPlayer';
use_ok( $module ) or exit;

can_ok( $module, 'new' );
my $song = $module->new( song => 'RomanceMe.mp3', player => 'xmms' );
isa_ok( $song, $module );

can_ok( $song, 'song' );
is( $song->song(  ), 'RomanceMe.mp3', 'song(  ) powinna zwrci piosenk podan w konstruktorze' );

can_ok( $song, 'player' );
is( $song->player(  ), 'xmms',
'player(  ) powinna zwrci odtwarzacz podany w konstruktorze' );

can_ok( $song, 'play' );

{
   package SongPlayer;

   use subs 'system';

   package main;

   my $fail = 0;
   my @args;

   *SongPlayer::system = sub
   {
      @args = @_;
      return $fail;
   };

   lives_ok { $song->play(  ) } 'play(  ) powinna przey pozytywne uruchomienie programu';

   is_deeply( \@args, [qw( xmms RomanceMe.mp3 )], 'play(  ) powinna wczy odtwarzanie piosenki' );

   $fail = 1;
   throws_ok { $song->play(  ) } qr/Nie udao si odtworzy RomanceMe.mp3 za pomoc xmms/, '...zgasza wyjtek w przypadku niepowodzenia uruchomienia...';
}
