package Queue::Word::Test;

use base 'Queue::Test';

use Queue::Word;
use Test::More;
use Test::Exception;

sub setup_queues : Test( setup => 2 )
{
   my ($self) = @_;

   $self->{empty}   = Queue::Word->new();
   $self->{twoitems} = Queue::Word->new(qw( czoem bonjour ));

   isa_ok( $self->{$_}, 'Queue::Word' ) for qw( empty twoitems );
}

sub check_only_words : Test(5)
{
   my ($self) = @_;

   lives_ok { $self->{empty}->enqueue('cojest') } "wcza sowa do kolejki";
   lives_ok { $self->{empty}->enqueue('CzE') } "wielko liter nie ma znaczenia";
   dies_ok  { $self->{empty}->enqueue(1981) } "nie da si umieci w kolejce liczb cakowitych";
   dies_ok  { $self->{empty}->enqueue(10.9) } "nie da si woy do kolejki liczb dziesitnych";
   dies_ok  { $self->{empty}->enqueue('Transzorp Diode') } "nie da si umieci w kolejce imion cyborgw";
}

1;
