use Test::More tests => 4;
use Test::Exception;
use Error;

sub add_positives
{
   my ( $l, $r ) = @_;
   throw Error::Simple("pierwszy argument ($l) jest ujemny") if $l < 0;
   throw Error::Simple("drugi argument ($r) jest ujemny") if $r < 0;
   return $l + $r;
}

throws_ok { add_positives( -7,  6 )} 'Error::Simple';
throws_ok { add_positives(  3, -9 )} 'Error::Simple';
throws_ok { add_positives( -5, -1 )} 'Error::Simple';
lives_ok  { add_positives(  4,  6 )} 'tutaj nie ma wyjtku!';
